/*
 * Decompiled with CFR 0.152.
 */
package org.weakref.jmx;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.weakref.jmx.MBean;
import org.weakref.jmx.MBeanBuilder;

public class MBeanExporter {
    private final MBeanServer server;

    public MBeanExporter(MBeanServer server) {
        this.server = server;
    }

    public void export(String name, Object object) {
        try {
            ObjectName objectName = new ObjectName(name);
            MBeanBuilder builder = new MBeanBuilder(object);
            MBean mbean = builder.build();
            this.server.registerMBean(mbean, objectName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unexport(String name) {
        try {
            ObjectName objectName = new ObjectName(name);
            this.server.unregisterMBean(objectName);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static MBeanExporter withPlatformMBeanServer() {
        return new MBeanExporter(ManagementFactory.getPlatformMBeanServer());
    }
}

