/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.data.impl;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.data.impl.AbstractDataWrapper;
import org.webpieces.data.impl.ByteBufferDataWrapper;
import org.webpieces.data.impl.ChainedDataWrapper;
import org.webpieces.data.impl.SliceableDataWrapper;
import org.webpieces.data.impl.SplitProxyWrapper;

public class DataWrapperGeneratorImpl
implements DataWrapperGenerator {
    private static final ByteBufferDataWrapper EMPTY_WRAPPER = new ByteBufferDataWrapper(ByteBuffer.allocate(0));

    @Override
    public DataWrapper wrapString(String string) {
        return this.wrapByteArray(string.getBytes());
    }

    @Override
    public DataWrapper wrapByteArray(byte[] data) {
        return new ByteBufferDataWrapper(ByteBuffer.wrap(data));
    }

    @Override
    public DataWrapper wrapByteArray(byte[] data, int offset, int length) {
        ByteBuffer buf = ByteBuffer.wrap(data, offset, length);
        return new ByteBufferDataWrapper(buf);
    }

    @Override
    public DataWrapper wrapByteBuffer(ByteBuffer buffer) {
        if (buffer.position() != 0) {
            throw new IllegalArgumentException("You probably forgot to call buffer.flip() so the buffer is made readable after writing to it.  position must be 0");
        }
        if (!buffer.hasRemaining()) {
            return DataWrapperGeneratorFactory.EMPTY;
        }
        return new ByteBufferDataWrapper(buffer);
    }

    @Override
    public DataWrapper chainDataWrappers(DataWrapper firstData, ByteBuffer ... secondData) {
        DataWrapper wrapper = firstData;
        for (ByteBuffer buffer : secondData) {
            DataWrapper second = this.wrapByteBuffer(buffer);
            wrapper = this.chainDataWrappers(wrapper, second);
        }
        return wrapper;
    }

    @Override
    public DataWrapper chainDataWrappers(DataWrapper firstData, DataWrapper ... theRest) {
        if (theRest.length == 0) {
            return firstData;
        }
        DataWrapper all = firstData;
        for (DataWrapper d : theRest) {
            all = this.chainDataWrappers(all, d);
        }
        return all;
    }

    @Override
    public DataWrapper chainDataWrappers(DataWrapper firstData, DataWrapper secondData) {
        if (firstData.getReadableSize() == 0) {
            return secondData;
        }
        if (secondData.getReadableSize() == 0) {
            return firstData;
        }
        if (firstData instanceof ChainedDataWrapper) {
            ChainedDataWrapper chained = (ChainedDataWrapper)firstData;
            ChainedDataWrapper newOne = new ChainedDataWrapper(chained.getWrappers());
            newOne.addMoreData(secondData);
            return newOne;
        }
        if (!(firstData instanceof SliceableDataWrapper)) {
            throw new IllegalArgumentException("Only SliceableDataWrappers or ChainedDataWrappers are allowed to be chained");
        }
        if (secondData instanceof ChainedDataWrapper) {
            ChainedDataWrapper wrapper = new ChainedDataWrapper((SliceableDataWrapper)firstData);
            wrapper.addMoreData(secondData);
            return wrapper;
        }
        if (!(secondData instanceof SliceableDataWrapper)) {
            throw new IllegalArgumentException("Only SliceableDataWrappers or ChainedDataWrappers are allowed to be chained");
        }
        SliceableDataWrapper first = (SliceableDataWrapper)firstData;
        SliceableDataWrapper second = (SliceableDataWrapper)secondData;
        return new ChainedDataWrapper(first, second);
    }

    @Override
    public DataWrapper emptyWrapper() {
        return EMPTY_WRAPPER;
    }

    @Override
    public List<? extends DataWrapper> split(DataWrapper dataToRead2, int splitAtPosition) {
        ArrayList<DataWrapper> tuple = new ArrayList<DataWrapper>();
        if (splitAtPosition > dataToRead2.getReadableSize()) {
            throw new IllegalArgumentException("splitPosition=" + splitAtPosition + " is greater than size of data=" + dataToRead2.getReadableSize());
        }
        if (dataToRead2.getReadableSize() == 0) {
            tuple.add(EMPTY_WRAPPER);
            tuple.add(EMPTY_WRAPPER);
            return tuple;
        }
        if (dataToRead2.getReadableSize() == splitAtPosition) {
            tuple.add(dataToRead2);
            tuple.add(EMPTY_WRAPPER);
            return tuple;
        }
        if (0 == splitAtPosition) {
            tuple.add(EMPTY_WRAPPER);
            tuple.add(dataToRead2);
            return tuple;
        }
        if (dataToRead2 instanceof ChainedDataWrapper) {
            return this.splitChainedWrapper((ChainedDataWrapper)dataToRead2, splitAtPosition);
        }
        if (!(dataToRead2 instanceof SliceableDataWrapper)) {
            throw new IllegalArgumentException("Only SliceableDataWrappers or ChainedDataWrappers are allowed to be split");
        }
        return this.splitTheSliceable((SliceableDataWrapper)dataToRead2, splitAtPosition);
    }

    List<SliceableDataWrapper> splitTheSliceable(SliceableDataWrapper dataToRead2, int splitAtPosition) {
        if (dataToRead2 instanceof SplitProxyWrapper) {
            return this.splitProxyUp((SplitProxyWrapper)dataToRead2, splitAtPosition);
        }
        SliceableDataWrapper dataToRead = dataToRead2;
        return this.splitSliceableWrapper(dataToRead, splitAtPosition);
    }

    private List<SliceableDataWrapper> splitProxyUp(SplitProxyWrapper dataToRead2, int splitAtPosition) {
        SliceableDataWrapper wrapper = dataToRead2.getWrapper();
        int offset = dataToRead2.getOffset();
        int length = dataToRead2.getLength();
        SplitProxyWrapper wrapper1 = new SplitProxyWrapper(wrapper, offset, splitAtPosition);
        SplitProxyWrapper wrapper2 = new SplitProxyWrapper(wrapper, offset + splitAtPosition, length - splitAtPosition);
        wrapper.increaseRefCount();
        ArrayList<SliceableDataWrapper> tuple = new ArrayList<SliceableDataWrapper>();
        tuple.add(wrapper1);
        tuple.add(wrapper2);
        return tuple;
    }

    private List<SliceableDataWrapper> splitSliceableWrapper(SliceableDataWrapper dataToRead, int splitAtPosition) {
        ArrayList<SliceableDataWrapper> tuple = new ArrayList<SliceableDataWrapper>();
        SplitProxyWrapper wrapper1 = new SplitProxyWrapper(dataToRead, 0, splitAtPosition);
        dataToRead.increaseRefCount();
        SplitProxyWrapper wrapper2 = new SplitProxyWrapper(dataToRead, splitAtPosition, dataToRead.getReadableSize() - splitAtPosition);
        tuple.add(wrapper1);
        tuple.add(wrapper2);
        return tuple;
    }

    private List<DataWrapper> splitChainedWrapper(ChainedDataWrapper dataToRead, int splitAtPosition) {
        ArrayList<SliceableDataWrapper> wrappersInBegin = new ArrayList<SliceableDataWrapper>();
        ArrayList<SliceableDataWrapper> wrappersInEnd = new ArrayList<SliceableDataWrapper>();
        boolean foundSplit = false;
        List<SliceableDataWrapper> splitBuffers = null;
        for (SliceableDataWrapper wrapper : dataToRead.getWrappers()) {
            if (!foundSplit) {
                if (splitAtPosition == wrapper.getReadableSize()) {
                    wrappersInBegin.add(wrapper);
                    foundSplit = true;
                    continue;
                }
                if (splitAtPosition < wrapper.getReadableSize()) {
                    splitBuffers = this.splitTheSliceable(wrapper, splitAtPosition);
                    wrappersInBegin.add(splitBuffers.get(0));
                    wrappersInEnd.add(splitBuffers.get(1));
                    foundSplit = true;
                    continue;
                }
                wrappersInBegin.add(wrapper);
                splitAtPosition -= wrapper.getReadableSize();
                continue;
            }
            wrappersInEnd.add(wrapper);
        }
        AbstractDataWrapper wrapper1 = wrappersInBegin.size() > 0 ? new ChainedDataWrapper(wrappersInBegin) : EMPTY_WRAPPER;
        AbstractDataWrapper wrapper2 = wrappersInEnd.size() > 0 ? new ChainedDataWrapper(wrappersInEnd) : EMPTY_WRAPPER;
        ArrayList<DataWrapper> finalTwo = new ArrayList<DataWrapper>();
        finalTwo.add(wrapper1);
        finalTwo.add(wrapper2);
        return finalTwo;
    }
}

