/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.plugins.fortesting;

import com.google.inject.Module;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.channels.ServerSocketChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.plugins.fortesting.SSLEngineFactoryWebServerTesting;
import org.webpieces.plugins.fortesting.TestConfig;
import org.webpieces.router.api.PortConfig;
import org.webpieces.router.api.RouterConfig;
import org.webpieces.templating.api.TemplateConfig;
import org.webpieces.util.file.FileFactory;
import org.webpieces.util.file.VirtualFile;
import org.webpieces.util.file.VirtualFileClasspath;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;
import org.webpieces.util.security.SecretKeyInfo;
import org.webpieces.webserver.api.WebServer;
import org.webpieces.webserver.api.WebServerConfig;
import org.webpieces.webserver.api.WebServerFactory;

public class WebserverForTest {
    private static final Logger log = LoggerFactory.getLogger(WebserverForTest.class);
    private File cacheDir = new File(System.getProperty("java.io.tmpdir") + "/webpiecesCache/webserverForTest");
    public static final Charset CHAR_SET_TO_USE = StandardCharsets.UTF_8;
    private WebServer webServer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws InterruptedException {
        new WebserverForTest(null, null, false, null).start();
        Class<WebserverForTest> clazz = WebserverForTest.class;
        synchronized (WebserverForTest.class) {
            WebserverForTest.class.wait();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public WebserverForTest(Module platformOverrides, Module appOverrides, boolean usePortZero, VirtualFile metaFile) {
        this(new TestConfig(platformOverrides, appOverrides, usePortZero, metaFile, true));
    }

    public WebserverForTest(TestConfig testConfig) {
        String filePath = System.getProperty("user.dir");
        log.info("property user.dir=" + filePath);
        VirtualFile metaFile = testConfig.getMetaFile();
        if (testConfig.getMetaFile() == null) {
            metaFile = new VirtualFileClasspath("basicMeta.txt", WebserverForTest.class.getClassLoader());
        }
        int httpPort = 8080;
        int httpsPort = 8443;
        if (testConfig.isUsePortZero()) {
            httpPort = 0;
            httpsPort = 0;
        }
        Module platformOverrides = testConfig.getPlatformOverrides();
        File baseWorkingDir = FileFactory.getBaseWorkingDir();
        WebServerConfig config = new WebServerConfig().setPlatformOverrides(platformOverrides).setHttpListenAddress(new InetSocketAddress(httpPort)).setHttpsListenAddress(new InetSocketAddress(httpsPort)).setSslEngineFactory((SSLEngineFactory)new SSLEngineFactoryWebServerTesting()).setFunctionToConfigureServerSocket(s -> this.configure((ServerSocketChannel)s));
        RouterConfig routerConfig = new RouterConfig(baseWorkingDir).setMetaFile(metaFile).setWebappOverrides(testConfig.getAppOverrides()).setFileEncoding(CHAR_SET_TO_USE).setDefaultResponseBodyEncoding(CHAR_SET_TO_USE).setCachedCompressedDirectory(this.cacheDir).setSecretKey(SecretKeyInfo.generateForTest()).setTokenCheckOn(testConfig.isUseTokenCheck()).setPortConfigCallback(() -> this.fetchPortsForRedirects());
        TemplateConfig templateConfig = new TemplateConfig();
        this.webServer = WebServerFactory.create((WebServerConfig)config, (RouterConfig)routerConfig, (TemplateConfig)templateConfig);
    }

    PortConfig fetchPortsForRedirects() {
        int httpPort = this.getUnderlyingHttpChannel().getLocalAddress().getPort();
        int httpsPort = this.getUnderlyingHttpsChannel().getLocalAddress().getPort();
        return new PortConfig(httpPort, httpsPort);
    }

    public void configure(ServerSocketChannel channel) throws SocketException {
        channel.socket().setReuseAddress(true);
    }

    public void start() {
        this.webServer.startSync();
    }

    public void stop() {
        this.webServer.stop();
    }

    public TCPServerChannel getUnderlyingHttpChannel() {
        return this.webServer.getUnderlyingHttpChannel();
    }

    public TCPServerChannel getUnderlyingHttpsChannel() {
        return this.webServer.getUnderlyingHttpsChannel();
    }

    public File getCacheDir() {
        return this.cacheDir;
    }
}

