/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.api;

import com.webpieces.hpack.api.HpackParser;
import com.webpieces.hpack.api.HpackParserFactory;
import com.webpieces.http2engine.api.server.Http2ServerEngineFactory;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.webpieces.asyncserver.api.AsyncServerManager;
import org.webpieces.asyncserver.api.AsyncServerMgrFactory;
import org.webpieces.data.api.BufferPool;
import org.webpieces.frontend2.api.HttpFrontendManager;
import org.webpieces.frontend2.api.ParsingLogic;
import org.webpieces.frontend2.impl.FrontEndServerManagerImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.nio.api.ChannelManagerFactory;
import org.webpieces.util.threading.NamedThreadFactory;

public abstract class HttpFrontendFactory {
    public static HttpFrontendManager createFrontEnd(String id, int threadPoolSize, ScheduledExecutorService timer, BufferPool pool) {
        ExecutorService executor = Executors.newFixedThreadPool(threadPoolSize, (ThreadFactory)new NamedThreadFactory(id));
        ChannelManagerFactory factory = ChannelManagerFactory.createFactory();
        ChannelManager chanMgr = factory.createMultiThreadedChanMgr(id, pool, (Executor)executor);
        AsyncServerManager svrMgr = AsyncServerMgrFactory.createAsyncServer((ChannelManager)chanMgr);
        return HttpFrontendFactory.createFrontEnd(svrMgr, timer, pool);
    }

    public static HttpFrontendManager createFrontEnd(AsyncServerManager svrMgr, ScheduledExecutorService timer, BufferPool pool) {
        HttpParser httpParser = HttpParserFactory.createParser((BufferPool)pool);
        HpackParser http2Parser = HpackParserFactory.createParser((BufferPool)pool, (boolean)true);
        Http2ServerEngineFactory svrEngineFactory = new Http2ServerEngineFactory();
        ParsingLogic parsing = new ParsingLogic(httpParser, http2Parser, svrEngineFactory);
        return HttpFrontendFactory.createFrontEnd(svrMgr, timer, pool, parsing);
    }

    public static HttpFrontendManager createFrontEnd(AsyncServerManager svrManager, ScheduledExecutorService svc, BufferPool bufferPool, ParsingLogic parsing) {
        return new FrontEndServerManagerImpl(svrManager, svc, bufferPool, parsing);
    }
}

