/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.http2engine.api.client.Http2Config;
import java.util.concurrent.ScheduledExecutorService;
import org.webpieces.asyncserver.api.AsyncServer;
import org.webpieces.asyncserver.api.AsyncServerManager;
import org.webpieces.data.api.BufferPool;
import org.webpieces.frontend2.api.FrontendConfig;
import org.webpieces.frontend2.api.HttpFrontendManager;
import org.webpieces.frontend2.api.HttpRequestListener;
import org.webpieces.frontend2.api.HttpServer;
import org.webpieces.frontend2.api.ParsingLogic;
import org.webpieces.frontend2.impl.HttpServerImpl;
import org.webpieces.frontend2.impl.Layer1ServerListener;
import org.webpieces.frontend2.impl.Layer2Http1_1Handler;
import org.webpieces.frontend2.impl.Layer2Http2Handler;
import org.webpieces.nio.api.SSLEngineFactory;
import org.webpieces.nio.api.handlers.AsyncDataListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class FrontEndServerManagerImpl
implements HttpFrontendManager {
    private static final Logger log = LoggerFactory.getLogger(FrontEndServerManagerImpl.class);
    private AsyncServerManager svrManager;
    private BufferPool bufferPool;
    private ScheduledExecutorService timer;
    private ParsingLogic parsing;

    public FrontEndServerManagerImpl(AsyncServerManager svrManager, ScheduledExecutorService svc, BufferPool bufferPool, ParsingLogic parsing) {
        this.timer = svc;
        this.svrManager = svrManager;
        this.bufferPool = bufferPool;
        this.parsing = parsing;
    }

    @Override
    public HttpServer createHttpServer(FrontendConfig config, HttpRequestListener httpListener) {
        this.preconditionCheck(config);
        Layer1ServerListener listener = this.buildDatalListener(httpListener, config.http2Config);
        AsyncServer tcpServer = this.svrManager.createTcpServer(config.asyncServerConfig, (AsyncDataListener)listener);
        HttpServerImpl frontend = new HttpServerImpl(tcpServer, config);
        return frontend;
    }

    private Layer1ServerListener buildDatalListener(HttpRequestListener httpListener, Http2Config config) {
        Layer2Http1_1Handler http1_1 = new Layer2Http1_1Handler(this.parsing.getHttpParser(), httpListener);
        Layer2Http2Handler http2 = new Layer2Http2Handler(this.parsing.getSvrEngineFactory(), this.parsing.getHttp2Parser(), httpListener, config);
        Layer1ServerListener listener = new Layer1ServerListener(http1_1, http2);
        return listener;
    }

    private void preconditionCheck(FrontendConfig config) {
        if (config.bindAddress == null) {
            throw new IllegalArgumentException("config.bindAddress must be set");
        }
        if (config.keepAliveTimeoutMs != null && this.timer == null) {
            throw new IllegalArgumentException("keepAliveTimeoutMs must be null since no timer was given when HttpFrontendFactory.createFrontEnd was called");
        }
        if (config.maxConnectToRequestTimeoutMs != null && this.timer == null) {
            throw new IllegalArgumentException("keepAliveTimeoutMs must be null since no timer was given when HttpFrontendFactory.createFrontEnd was called");
        }
    }

    @Override
    public HttpServer createHttpsServer(FrontendConfig config, HttpRequestListener httpListener, SSLEngineFactory factory) {
        this.preconditionCheck(config);
        Layer1ServerListener listener = this.buildDatalListener(httpListener, config.http2Config);
        AsyncServer tcpServer = this.svrManager.createTcpServer(config.asyncServerConfig, (AsyncDataListener)listener, factory);
        HttpServerImpl frontend = new HttpServerImpl(tcpServer, config);
        return frontend;
    }
}

