/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.hpack.api.dto.Http2Push;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.lib.PartialStream;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.frontend2.api.FrontendSocket;
import org.webpieces.frontend2.api.FrontendStream;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.translation.Http2Translations;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpResponse;

public class Http1_1StreamImpl
implements FrontendStream {
    private FrontendSocketImpl socket;
    private HttpParser http11Parser;

    public Http1_1StreamImpl(FrontendSocketImpl socket, HttpParser http11Parser) {
        this.socket = socket;
        this.http11Parser = http11Parser;
    }

    @Override
    public StreamWriter sendResponse(Http2Headers headers) {
        HttpResponse response = Http2Translations.translateResponse(headers);
        ByteBuffer buf = this.http11Parser.marshalToByteBuffer((HttpPayload)response);
        this.socket.write(buf);
        return new StreamImpl();
    }

    @Override
    public StreamWriter sendPush(Http2Push push) {
        throw new UnsupportedOperationException("not supported for http1.1 requests");
    }

    @Override
    public void cancelStream() {
        throw new UnsupportedOperationException("not supported for http1.1 requests.  you can use getSocket().close() instead if you like");
    }

    @Override
    public FrontendSocket getSocket() {
        return this.socket;
    }

    private class StreamImpl
    implements StreamWriter {
        private StreamImpl() {
        }

        public CompletableFuture<StreamWriter> sendMore(PartialStream data) {
            HttpPayload response = Http2Translations.translate(data);
            ByteBuffer buf = Http1_1StreamImpl.this.http11Parser.marshalToByteBuffer(response);
            return Http1_1StreamImpl.this.socket.write(buf).thenApply(s -> this);
        }
    }
}

