/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.hpack.api.dto.Http2Push;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2engine.api.server.ResponseHandler;
import org.webpieces.frontend2.api.FrontendSocket;
import org.webpieces.frontend2.api.FrontendStream;
import org.webpieces.frontend2.impl.FrontendSocketImpl;

public class Http2StreamImpl
implements FrontendStream {
    private FrontendSocketImpl socket;
    private boolean sentResponseHeaders;
    private ResponseHandler responseHandler;

    public Http2StreamImpl(FrontendSocketImpl socket, ResponseHandler responseHandler) {
        this.socket = socket;
        this.responseHandler = responseHandler;
    }

    @Override
    public StreamWriter sendResponse(Http2Headers headers) {
        this.sentResponseHeaders = true;
        return this.responseHandler.sendResponse(headers);
    }

    @Override
    public StreamWriter sendPush(Http2Push push) {
        if (this.sentResponseHeaders) {
            throw new IllegalStateException("You must call sendPush before sendResponse, but after that can send both datastreams back at the same time(see http2 spec for why)");
        }
        return this.responseHandler.sendPush(push);
    }

    @Override
    public void cancelStream() {
        this.responseHandler.cancelStream();
    }

    @Override
    public FrontendSocket getSocket() {
        return this.socket;
    }
}

