/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.api.AsyncServer;
import org.webpieces.frontend2.api.FrontendConfig;
import org.webpieces.frontend2.api.HttpServer;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HttpServerImpl
implements HttpServer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private AsyncServer server;
    private FrontendConfig config;

    public HttpServerImpl(AsyncServer server, FrontendConfig config) {
        this.server = server;
        this.config = config;
    }

    @Override
    public void start() {
        log.info("starting to listen to port=" + this.config.bindAddress);
        this.server.start(this.config.bindAddress);
        log.info("now listening for incoming requests");
    }

    @Override
    public CompletableFuture<Void> close() {
        return this.server.closeServerChannel();
    }

    @Override
    public void enableOverloadMode(ByteBuffer overloadResponse) {
        this.server.enableOverloadMode(overloadResponse);
    }

    @Override
    public void disableOverloadMode() {
        this.server.disableOverloadMode();
    }

    @Override
    public TCPServerChannel getUnderlyingChannel() {
        return this.server.getUnderlyingChannel();
    }
}

