/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import java.nio.ByteBuffer;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.InitiationResult;
import org.webpieces.frontend2.impl.InitiationStatus;
import org.webpieces.frontend2.impl.Layer2Http1_1Handler;
import org.webpieces.frontend2.impl.Layer2Http2Handler;
import org.webpieces.frontend2.impl.ProtocolType;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.nio.api.channels.TCPChannel;
import org.webpieces.nio.api.handlers.AsyncDataListener;

public class Layer1ServerListener
implements AsyncDataListener {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private static final String FRONTEND_SOCKET = "__frontendSocket";
    private Layer2Http1_1Handler http1_1Handler;
    private Layer2Http2Handler http2Handler;

    public Layer1ServerListener(Layer2Http1_1Handler http1_1Listener, Layer2Http2Handler http2Listener) {
        this.http1_1Handler = http1_1Listener;
        this.http2Handler = http2Listener;
    }

    public void incomingData(Channel channel, ByteBuffer b) {
        FrontendSocketImpl socket = this.getSocket(channel);
        switch (socket.getProtocol()) {
            case HTTP2: {
                this.http2Handler.incomingData(socket, b);
                break;
            }
            case HTTP1_1: {
                this.http1_1Handler.incomingData(socket, b);
                break;
            }
            case UNKNOWN: {
                this.initialData(b, socket);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown protocol=" + (Object)((Object)socket.getProtocol()));
            }
        }
    }

    private void initialData(ByteBuffer b, FrontendSocketImpl socket) {
        InitiationResult initialData = this.http1_1Handler.initialData(socket, b);
        if (initialData == null) {
            return;
        }
        if (initialData.getInitialStatus() == InitiationStatus.HTTP1_1) {
            socket.setProtocol(ProtocolType.HTTP1_1);
        } else if (initialData.getInitialStatus() == InitiationStatus.PREFACE) {
            socket.setProtocol(ProtocolType.HTTP2);
            this.http2Handler.initialize(socket);
        } else {
            throw new UnsupportedOperationException("Did not implement case=" + (Object)((Object)initialData.getInitialStatus()) + " yet");
        }
    }

    public void farEndClosed(Channel channel) {
        FrontendSocketImpl socket = this.getSocket(channel);
        switch (socket.getProtocol()) {
            case HTTP2: {
                this.http2Handler.farEndClosed(socket);
                break;
            }
            case HTTP1_1: {
                this.http1_1Handler.farEndClosed(socket);
                break;
            }
            case UNKNOWN: {
                break;
            }
            default: {
                throw new IllegalStateException("Unknown protocol=" + (Object)((Object)socket.getProtocol()));
            }
        }
    }

    public void failure(Channel channel, ByteBuffer data, Exception e) {
    }

    public void applyBackPressure(Channel channel) {
    }

    public void releaseBackPressure(Channel channel) {
    }

    public void connectionOpened(TCPChannel channel, boolean isReadyForWrites) {
        FrontendSocketImpl socket = new FrontendSocketImpl(channel, ProtocolType.UNKNOWN);
        channel.getSession().put((Object)FRONTEND_SOCKET, (Object)socket);
        this.http1_1Handler.socketOpened(socket, isReadyForWrites);
    }

    FrontendSocketImpl getSocket(Channel channel) {
        return (FrontendSocketImpl)channel.getSession().get((Object)FRONTEND_SOCKET);
    }
}

