/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.lib.Http2Msg;
import java.nio.ByteBuffer;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.frontend2.api.HttpRequestListener;
import org.webpieces.frontend2.api.Protocol;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.Http1_1StreamImpl;
import org.webpieces.frontend2.impl.InitiationResult;
import org.webpieces.frontend2.impl.InitiationStatus;
import org.webpieces.frontend2.impl.translation.Http2Translations;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.Memento;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpMessageType;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer2Http1_1Handler {
    private static final Logger log = LoggerFactory.getLogger(Layer2Http1_1Handler.class);
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private HttpParser httpParser;
    private HttpRequestListener httpListener;

    public Layer2Http1_1Handler(HttpParser httpParser, HttpRequestListener httpListener) {
        this.httpParser = httpParser;
        this.httpListener = httpListener;
    }

    public InitiationResult initialData(FrontendSocketImpl socket, ByteBuffer buf) {
        Memento state = this.parse(socket, buf);
        InitiationResult result = this.checkForPreface(socket, state);
        if (result != null) {
            return result;
        }
        if (state.getParsedMessages().size() >= 0) {
            this.processHttp1Messages(socket, state);
            return new InitiationResult(InitiationStatus.HTTP1_1);
        }
        return null;
    }

    private InitiationResult checkForPreface(FrontendSocketImpl socket, Memento state) {
        if (state.getParsedMessages().size() != 1) {
            return null;
        }
        if (((HttpPayload)state.getParsedMessages().get(0)).getMessageType() != HttpMessageType.HTTP2_MARKER_MSG) {
            return null;
        }
        socket.setHttp1_1ParseState(null);
        return new InitiationResult(state.getLeftOverData(), InitiationStatus.PREFACE);
    }

    public void incomingData(FrontendSocketImpl socket, ByteBuffer buf) {
        Memento state = this.parse(socket, buf);
        this.processHttp1Messages(socket, state);
    }

    private Memento parse(FrontendSocketImpl socket, ByteBuffer buf) {
        DataWrapper moreData = dataGen.wrapByteBuffer(buf);
        Memento state = socket.getHttp1_1ParseState();
        state = this.httpParser.parse(state, moreData);
        return state;
    }

    private void processHttp1Messages(FrontendSocketImpl socket, Memento state) {
        List parsed = state.getParsedMessages();
        for (HttpPayload payload : parsed) {
            log.info("msg received=" + payload);
            this.processCorrectly(socket, payload);
        }
    }

    private void processCorrectly(FrontendSocketImpl socket, HttpPayload payload) {
        Http2Msg msg = Http2Translations.translate(payload);
        if (payload instanceof HttpRequest) {
            Http2Headers headers = (Http2Headers)msg;
            Http1_1StreamImpl stream = new Http1_1StreamImpl(socket, this.httpParser);
            StreamWriter streamWriter = this.httpListener.incomingRequest(stream, headers, Protocol.HTTP11);
        } else if (!(payload instanceof HttpChunk) && !(payload instanceof HttpLastChunk)) {
            throw new IllegalArgumentException("payload not supported=" + payload);
        }
    }

    public void farEndClosed(FrontendSocketImpl socket) {
        this.httpListener.socketClosed(socket);
    }

    public void socketOpened(FrontendSocketImpl socket, boolean isReadyForWrites) {
        Memento parseState = this.httpParser.prepareToParse();
        socket.setHttp1_1ParseState(parseState);
    }
}

