/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Headers;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2engine.api.server.ResponseHandler;
import com.webpieces.http2engine.api.server.ServerEngineListener;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.frontend2.api.HttpRequestListener;
import org.webpieces.frontend2.api.Protocol;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.Http2StreamImpl;

public class Layer3Http2EngineListener
implements ServerEngineListener {
    private FrontendSocketImpl socket;
    private HttpRequestListener httpListener;

    public Layer3Http2EngineListener(FrontendSocketImpl socket, HttpRequestListener httpListener) {
        this.socket = socket;
        this.httpListener = httpListener;
    }

    public StreamWriter sendRequestToClient(Http2Headers request, ResponseHandler responseHandler) {
        Http2StreamImpl stream = new Http2StreamImpl(this.socket, responseHandler);
        return this.httpListener.incomingRequest(stream, request, Protocol.HTTP2);
    }

    public CompletableFuture<Void> sendToSocket(ByteBuffer newData) {
        return this.socket.getChannel().write(newData).thenApply(c -> null);
    }

    public void engineClosedByFarEnd() {
        this.httpListener.socketClosed(this.socket);
    }
}

