/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Response;
import com.webpieces.http2engine.api.PushStreamHandle;
import com.webpieces.http2engine.api.ResponseHandler;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.CancelReason;
import com.webpieces.http2parser.api.dto.RstStreamFrame;
import com.webpieces.http2parser.api.dto.lib.Http2ErrorCode;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webpieces.frontend2.api.FrontendSocket;
import org.webpieces.frontend2.api.ResponseStream;
import org.webpieces.frontend2.api.StreamSession;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.Http2PushStreamHandle;
import org.webpieces.frontend2.impl.StreamSessionImpl;

public class Http2StreamImpl
implements ResponseStream {
    private FrontendSocketImpl socket;
    private AtomicBoolean sentResponseHeaders = new AtomicBoolean(false);
    private ResponseHandler responseHandler;
    private StreamSession session = new StreamSessionImpl();
    private int streamId;

    public Http2StreamImpl(FrontendSocketImpl socket, ResponseHandler responseHandler, int streamId) {
        this.socket = socket;
        this.responseHandler = responseHandler;
        this.streamId = streamId;
    }

    @Override
    public CompletableFuture<StreamWriter> sendResponse(Http2Response resp) {
        this.sentResponseHeaders.set(true);
        return this.responseHandler.process(resp);
    }

    @Override
    public PushStreamHandle openPushStream() {
        PushStreamHandle pushStream = this.responseHandler.openPushStream();
        return new Http2PushStreamHandle(pushStream, this.sentResponseHeaders);
    }

    @Override
    public CompletableFuture<Void> cancelStream() {
        RstStreamFrame frame = new RstStreamFrame(this.streamId, Http2ErrorCode.CANCEL);
        return this.responseHandler.cancel((CancelReason)frame);
    }

    @Override
    public FrontendSocket getSocket() {
        return this.socket;
    }

    @Override
    public StreamSession getSession() {
        return this.session;
    }

    public String toString() {
        return "Http2Stream[" + this.socket + ", sId=" + this.streamId + "]";
    }
}

