/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.asyncserver.api.AsyncServer;
import org.webpieces.frontend2.api.HttpServer;
import org.webpieces.frontend2.api.HttpSvrConfig;
import org.webpieces.frontend2.impl.Layer1ServerListener;
import org.webpieces.nio.api.channels.TCPServerChannel;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class HttpServerImpl
implements HttpServer {
    private static final Logger log = LoggerFactory.getLogger(HttpServerImpl.class);
    private AsyncServer server;
    private HttpSvrConfig config;
    private Layer1ServerListener listener;
    private boolean started;

    public HttpServerImpl(AsyncServer server, HttpSvrConfig config, Layer1ServerListener listener) {
        this.server = server;
        this.config = config;
        this.listener = listener;
    }

    @Override
    public CompletableFuture<Void> start() {
        log.info("starting to listen to port=" + this.config.bindAddress);
        CompletableFuture future = this.server.start(this.config.bindAddress);
        return future.thenApply(v -> {
            InetSocketAddress localAddr = this.server.getUnderlyingChannel().getLocalAddress();
            this.listener.setSvrSocketAddr(localAddr);
            this.started = true;
            log.info("now listening for incoming requests on " + localAddr);
            return null;
        });
    }

    @Override
    public CompletableFuture<Void> close() {
        if (!this.started) {
            throw new IllegalArgumentException("The server was not fully started yet.  you cannot close it until id is started");
        }
        return this.server.closeServerChannel();
    }

    @Override
    public void enableOverloadMode(ByteBuffer overloadResponse) {
        this.server.enableOverloadMode(overloadResponse);
    }

    @Override
    public void disableOverloadMode() {
        this.server.disableOverloadMode();
    }

    @Override
    public TCPServerChannel getUnderlyingChannel() {
        return this.server.getUnderlyingChannel();
    }
}

