/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Request;
import com.webpieces.http2engine.api.ResponseHandler;
import com.webpieces.http2engine.api.StreamHandle;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2engine.api.error.ShutdownConnection;
import com.webpieces.http2engine.api.server.ServerEngineListener;
import com.webpieces.http2parser.api.dto.CancelReason;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.frontend2.api.HttpStream;
import org.webpieces.frontend2.api.StreamListener;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.Http2StreamImpl;
import org.webpieces.nio.api.exceptions.NioClosedChannelException;

public class Layer3Http2EngineListener
implements ServerEngineListener {
    private FrontendSocketImpl socket;
    private StreamListener httpListener;

    public Layer3Http2EngineListener(FrontendSocketImpl socket, StreamListener httpListener) {
        this.socket = socket;
        this.httpListener = httpListener;
    }

    public StreamHandle openStream() {
        HttpStream handle2 = this.httpListener.openStream();
        return new FrontendStreamProxy(handle2);
    }

    public CompletableFuture<Void> sendToSocket(ByteBuffer newData) {
        try {
            return this.socket.getChannel().write(newData).thenApply(c -> null);
        }
        catch (NioClosedChannelException e) {
            CompletableFuture<Void> f = new CompletableFuture<Void>();
            f.completeExceptionally(e);
            return f;
        }
    }

    public void closeSocket(ShutdownConnection reason) {
        this.socket.internalClose();
    }

    private class FrontendStreamProxy
    implements StreamHandle {
        private HttpStream handle2;

        public FrontendStreamProxy(HttpStream handle2) {
            this.handle2 = handle2;
        }

        public CompletableFuture<StreamWriter> process(Http2Request request, ResponseHandler responseListener) {
            Http2StreamImpl stream = new Http2StreamImpl(Layer3Http2EngineListener.this.socket, responseListener, request.getStreamId());
            return this.handle2.incomingRequest(request, stream);
        }

        public CompletableFuture<Void> cancel(CancelReason payload) {
            return this.handle2.incomingCancel(payload);
        }
    }
}

