/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.http2engine.api.server.Http2ServerEngineFactory;
import java.util.concurrent.ScheduledExecutorService;
import org.webpieces.asyncserver.api.AsyncDataListener;
import org.webpieces.asyncserver.api.AsyncServer;
import org.webpieces.asyncserver.api.AsyncServerManager;
import org.webpieces.frontend2.api.HttpFrontendManager;
import org.webpieces.frontend2.api.HttpServer;
import org.webpieces.frontend2.api.HttpSvrConfig;
import org.webpieces.frontend2.api.StreamListener;
import org.webpieces.frontend2.impl.HttpServerImpl;
import org.webpieces.frontend2.impl.Layer1ServerListener;
import org.webpieces.frontend2.impl.Layer2Http1_1Handler;
import org.webpieces.frontend2.impl.Layer2Http2Handler;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.nio.api.SSLEngineFactory;

public class FrontEndServerManagerImpl
implements HttpFrontendManager {
    private AsyncServerManager svrManager;
    private ScheduledExecutorService timer;
    private HttpParser httpParser;
    private Http2ServerEngineFactory http2EngineFactory;

    public FrontEndServerManagerImpl(AsyncServerManager svrManager, ScheduledExecutorService svc, Http2ServerEngineFactory http2EngineFactory, HttpParser httpParser) {
        this.timer = svc;
        this.svrManager = svrManager;
        this.http2EngineFactory = http2EngineFactory;
        this.httpParser = httpParser;
    }

    @Override
    public HttpServer createHttpServer(HttpSvrConfig config, StreamListener httpListener) {
        this.preconditionCheck(config);
        Layer1ServerListener listener = this.buildDatalListener(httpListener, false);
        AsyncServer tcpServer = this.svrManager.createTcpServer(config.asyncServerConfig, (AsyncDataListener)listener);
        HttpServerImpl frontend = new HttpServerImpl(tcpServer, config, listener);
        return frontend;
    }

    private Layer1ServerListener buildDatalListener(StreamListener httpListener, boolean isHttps) {
        Layer2Http1_1Handler http1_1 = new Layer2Http1_1Handler(this.httpParser, httpListener);
        Layer2Http2Handler http2 = new Layer2Http2Handler(this.http2EngineFactory, httpListener);
        Layer1ServerListener listener = new Layer1ServerListener(http1_1, http2, isHttps);
        return listener;
    }

    private void preconditionCheck(HttpSvrConfig config) {
        if (config.bindAddress == null) {
            throw new IllegalArgumentException("config.bindAddress must be set");
        }
        if (config.keepAliveTimeoutMs != null && this.timer == null) {
            throw new IllegalArgumentException("keepAliveTimeoutMs must be null since no timer was given when HttpFrontendFactory.createFrontEnd was called");
        }
        if (config.maxConnectToRequestTimeoutMs != null && this.timer == null) {
            throw new IllegalArgumentException("keepAliveTimeoutMs must be null since no timer was given when HttpFrontendFactory.createFrontEnd was called");
        }
    }

    @Override
    public HttpServer createHttpsServer(HttpSvrConfig config, StreamListener httpListener, SSLEngineFactory factory) {
        this.preconditionCheck(config);
        Layer1ServerListener listener = this.buildDatalListener(httpListener, true);
        AsyncServer tcpServer = this.svrManager.createTcpServer(config.asyncServerConfig, (AsyncDataListener)listener, factory);
        HttpServerImpl frontend = new HttpServerImpl(tcpServer, config, listener);
        return frontend;
    }
}

