/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.hpack.api.dto.Http2Response;
import com.webpieces.http2engine.api.PushStreamHandle;
import com.webpieces.http2engine.api.StreamWriter;
import com.webpieces.http2parser.api.dto.DataFrame;
import com.webpieces.http2parser.api.dto.lib.Http2Header;
import com.webpieces.http2parser.api.dto.lib.Http2HeaderName;
import com.webpieces.http2parser.api.dto.lib.Http2Msg;
import com.webpieces.http2parser.api.dto.lib.StreamMsg;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import org.webpieces.frontend2.api.FrontendSocket;
import org.webpieces.frontend2.api.HttpStream;
import org.webpieces.frontend2.api.ResponseStream;
import org.webpieces.frontend2.api.StreamSession;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.StreamSessionImpl;
import org.webpieces.http2translations.api.Http2ToHttp1_1;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.common.Header;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpData;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpPayload;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.util.locking.PermitQueue;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Http1_1StreamImpl
implements ResponseStream {
    private static final Logger log = LoggerFactory.getLogger(Http1_1StreamImpl.class);
    private FrontendSocketImpl socket;
    private HttpParser http11Parser;
    private AtomicReference<Http2Msg> endingFrame = new AtomicReference();
    private StreamSession session = new StreamSessionImpl();
    private HttpStream streamHandle;
    private int streamId;
    private StreamWriter requestWriter;
    private PermitQueue permitQueue;
    private boolean sentFullRequest;

    public Http1_1StreamImpl(int streamId, FrontendSocketImpl socket, HttpParser http11Parser, PermitQueue permitQueue) {
        this.streamId = streamId;
        this.socket = socket;
        this.http11Parser = http11Parser;
        this.permitQueue = permitQueue;
    }

    @Override
    public CompletableFuture<StreamWriter> sendResponse(Http2Response headers) {
        this.closeCheck();
        HttpResponse response = Http2ToHttp1_1.translateResponse((Http2Response)headers);
        if (headers.isEndOfStream()) {
            this.validateHeader(response);
            this.remove((Http2Msg)headers);
            return this.write((HttpPayload)response).thenApply(w -> {
                this.permitQueue.releasePermit();
                return new NoWritesWriter();
            });
        }
        if (this.contentLengthGreaterThanZero(headers)) {
            return this.write((HttpPayload)response).thenApply(w -> new ContentLengthResponseWriter(headers));
        }
        return this.write((HttpPayload)response).thenApply(c -> new Http11ChunkedWriter());
    }

    private void closeCheck() {
        if (this.endingFrame.get() != null) {
            throw new IllegalArgumentException("You already sent a frame with endOfStream=true so cannot send more data");
        }
    }

    private void validateHeader(HttpResponse response) {
        Header contentLenHeader = response.getHeaderLookupStruct().getHeader(KnownHeaderName.CONTENT_LENGTH);
        if (contentLenHeader == null) {
            throw new IllegalArgumentException("Content Length header required and missing and should be set to zero");
        }
        if (contentLenHeader.getValue() == null) {
            throw new IllegalArgumentException("Content Length header found but it's value is null");
        }
        int len = Integer.parseInt(contentLenHeader.getValue());
        if (len != 0) {
            throw new IllegalArgumentException("Content Length header found but it's value is 0 while response.isEndOfStream is true.  this is contradictory");
        }
    }

    private boolean contentLengthGreaterThanZero(Http2Response headers) {
        Http2Header contentLenHeader = headers.getHeaderLookupStruct().getHeader(Http2HeaderName.CONTENT_LENGTH);
        if (contentLenHeader != null) {
            int len = Integer.parseInt(contentLenHeader.getValue());
            if (len > 0) {
                return true;
            }
            if (len == 0 && !headers.isEndOfStream()) {
                throw new IllegalStateException("Content-Length=0 but response.isEndOfStream==false");
            }
        }
        return false;
    }

    private void remove(Http2Msg data) {
        Http1_1StreamImpl current = this.socket.getCurrentStream();
        if (!this.sentFullRequest) {
            throw new IllegalStateException("Client Application cannot send endof stream message until the full request is sent(only in http1.1)");
        }
        if (this.endingFrame.get() != null) {
            throw new IllegalStateException("You had already sent a frame with endOfStream set and can't send more.  ending frame was=" + this.endingFrame + " but you just sent=" + data);
        }
        if (current != this) {
            throw new IllegalStateException("Due to http1.1 spec, YOU MUST return responses in order and this is not the current response that needs responding to");
        }
        this.endingFrame.set(data);
        this.socket.setCurrentStream(null);
    }

    private CompletableFuture<Void> write(HttpPayload payload) {
        ByteBuffer buf = this.http11Parser.marshalToByteBuffer(this.socket.getHttp1_1MarshalState(), payload);
        return this.socket.getChannel().write(buf);
    }

    @Override
    public PushStreamHandle openPushStream() {
        throw new UnsupportedOperationException("not supported for http1.1 requests");
    }

    @Override
    public CompletableFuture<Void> cancelStream() {
        throw new UnsupportedOperationException("not supported for http1.1 requests.  you can use getSocket().close() instead if you like");
    }

    @Override
    public FrontendSocket getSocket() {
        return this.socket;
    }

    @Override
    public StreamSession getSession() {
        return this.session;
    }

    public void setStreamHandle(HttpStream streamHandle2) {
        this.streamHandle = streamHandle2;
    }

    public HttpStream getStreamHandle() {
        return this.streamHandle;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public StreamWriter getRequestWriter() {
        return this.requestWriter;
    }

    public void setRequestWriter(StreamWriter requestWriter) {
        this.requestWriter = requestWriter;
    }

    public void setSentFullRequest(boolean sent) {
        this.sentFullRequest = sent;
    }

    private class Http11ChunkedWriter
    implements StreamWriter {
        private Http11ChunkedWriter() {
        }

        public CompletableFuture<Void> processPiece(StreamMsg data) {
            Http1_1StreamImpl.this.closeCheck();
            if (!(data instanceof DataFrame)) {
                throw new UnsupportedOperationException("not supported in http1.1=" + data);
            }
            DataFrame frame = (DataFrame)data;
            CompletionStage future = Http1_1StreamImpl.this.write((HttpPayload)new HttpChunk(frame.getData()));
            if (data.isEndOfStream()) {
                Http1_1StreamImpl.this.remove((Http2Msg)data);
                log.info(Http1_1StreamImpl.this.socket + " done sending response");
                future = ((CompletableFuture)future.thenCompose(w -> Http1_1StreamImpl.this.write((HttpPayload)new HttpLastChunk()))).thenApply(v -> {
                    Http1_1StreamImpl.this.permitQueue.releasePermit();
                    return null;
                });
            }
            return future;
        }
    }

    private class ContentLengthResponseWriter
    implements StreamWriter {
        private int len;
        private int totalWritten;

        public ContentLengthResponseWriter(Http2Response response) {
            Http2Header contentLenHeader = response.getHeaderLookupStruct().getHeader(Http2HeaderName.CONTENT_LENGTH);
            this.len = Integer.parseInt(contentLenHeader.getValue());
        }

        public CompletableFuture<Void> processPiece(StreamMsg data) {
            Http1_1StreamImpl.this.closeCheck();
            if (!(data instanceof DataFrame)) {
                throw new UnsupportedOperationException("not supported in http1.1=" + data);
            }
            DataFrame frame = (DataFrame)data;
            this.totalWritten += frame.getData().getReadableSize();
            if (this.totalWritten > this.len) {
                throw new IllegalArgumentException("You wrote more than the content length header=" + this.len + " written size=" + this.totalWritten);
            }
            if (frame.isEndOfStream() && this.totalWritten != this.len) {
                throw new IllegalArgumentException("You did not write enough data.  written=" + this.totalWritten + " content length header=" + this.len);
            }
            if (frame.isEndOfStream()) {
                log.info(Http1_1StreamImpl.this.socket + " done sending response2");
                Http1_1StreamImpl.this.remove((Http2Msg)data);
            }
            HttpData httpData = new HttpData(frame.getData(), frame.isEndOfStream());
            return Http1_1StreamImpl.this.write((HttpPayload)httpData).thenApply(c -> {
                if (frame.isEndOfStream()) {
                    Http1_1StreamImpl.this.permitQueue.releasePermit();
                }
                return null;
            });
        }
    }

    private class NoWritesWriter
    implements StreamWriter {
        private NoWritesWriter() {
        }

        public CompletableFuture<Void> processPiece(StreamMsg data) {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            future.completeExceptionally(new IllegalStateException("You already sent a response with endStream==true"));
            return future;
        }
    }
}

