/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.frontend2.impl;

import com.webpieces.http2engine.api.server.Http2ServerEngine;
import com.webpieces.http2engine.api.server.Http2ServerEngineFactory;
import com.webpieces.http2engine.api.server.ServerEngineListener;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;
import org.webpieces.frontend2.api.StreamListener;
import org.webpieces.frontend2.impl.FrontendSocketImpl;
import org.webpieces.frontend2.impl.Layer3Http2EngineListener;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;

public class Layer2Http2Handler {
    private static final Logger log = LoggerFactory.getLogger(Layer2Http2Handler.class);
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private Http2ServerEngineFactory svrEngineFactory;
    private StreamListener httpListener;

    public Layer2Http2Handler(Http2ServerEngineFactory svrEngineFactory, StreamListener httpListener) {
        this.svrEngineFactory = svrEngineFactory;
        this.httpListener = httpListener;
    }

    public void initialize(FrontendSocketImpl socket) {
        Layer3Http2EngineListener listener = new Layer3Http2EngineListener(socket, this.httpListener);
        Http2ServerEngine engine = this.svrEngineFactory.createEngine("" + socket, (ServerEngineListener)listener);
        socket.setHttp2Engine(engine);
        engine.intialize();
    }

    public CompletableFuture<Void> incomingData(FrontendSocketImpl socket, ByteBuffer b) {
        DataWrapper wrapper = dataGen.wrapByteBuffer(b);
        return this.incomingData(socket, wrapper);
    }

    public CompletableFuture<Void> incomingData(FrontendSocketImpl socket, DataWrapper data) {
        Http2ServerEngine engine = socket.getHttp2Engine();
        return engine.parse(data);
    }

    public void farEndClosed(FrontendSocketImpl socket) {
        log.error("far end closed=" + socket);
        Http2ServerEngine engine = socket.getHttp2Engine();
        engine.farEndClosed();
    }
}

