/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import com.webpieces.http2parser.api.dto.HasHeaderFragment;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.httpcommon.api.Protocol;
import org.webpieces.httpcommon.api.RequestId;
import org.webpieces.httpcommon.api.ResponseId;
import org.webpieces.httpcommon.api.ResponseSender;
import org.webpieces.httpcommon.api.exceptions.HttpException;
import org.webpieces.httpparser.api.common.KnownHeaderName;
import org.webpieces.httpparser.api.dto.HttpChunk;
import org.webpieces.httpparser.api.dto.HttpLastChunk;
import org.webpieces.httpparser.api.dto.HttpRequest;
import org.webpieces.httpparser.api.dto.HttpResponse;
import org.webpieces.nio.api.channels.Channel;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;
import org.webpieces.webserver.test.FullResponse;

public class MockResponseSender
implements ResponseSender {
    private static final Logger log = LoggerFactory.getLogger(MockResponseSender.class);
    private List<FullResponse> payloads = new ArrayList<FullResponse>();
    private FullResponse chunkedResponse;

    public Protocol getProtocol() {
        return null;
    }

    public CompletableFuture<Void> close() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> sendData(DataWrapper data, ResponseId id, boolean isLastData) {
        if (isLastData) {
            HttpLastChunk chunk = new HttpLastChunk();
            chunk.setBody(data);
            this.chunkedResponse.setLastChunk(chunk);
            this.payloads.add(this.chunkedResponse);
            this.chunkedResponse = null;
            MockResponseSender mockResponseSender = this;
            synchronized (mockResponseSender) {
                this.notifyAll();
            }
        } else {
            HttpChunk chunk = new HttpChunk();
            chunk.setBody(data);
            this.chunkedResponse.addChunk(chunk);
        }
        return null;
    }

    public void sendTrailer(List<HasHeaderFragment.Header> headerList, ResponseId id, boolean isComplete) {
        throw new UnsupportedOperationException();
    }

    public CompletableFuture<Void> sendException(HttpException e) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CompletableFuture<ResponseId> sendResponse(HttpResponse response, HttpRequest request, RequestId requestId, boolean isComplete) {
        if (this.chunkedResponse == null) {
            FullResponse nextResp = new FullResponse(response);
            if (response.getHeaderLookupStruct().getHeader(KnownHeaderName.CONTENT_LENGTH) != null) {
                this.payloads.add(nextResp);
                MockResponseSender mockResponseSender = this;
                synchronized (mockResponseSender) {
                    this.notifyAll();
                }
            } else {
                this.chunkedResponse = nextResp;
            }
        } else {
            log.error("expecting sendData but got Response instead=" + response);
        }
        return CompletableFuture.completedFuture(new ResponseId(0));
    }

    public Channel getUnderlyingChannel() {
        return null;
    }

    public List<FullResponse> getResponses() {
        return this.payloads;
    }

    public synchronized List<FullResponse> getResponses(long waitTimeMs, int count) {
        try {
            return this.getResponsesImpl(waitTimeMs, count);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("failed waiting", e);
        }
    }

    public synchronized List<FullResponse> getResponsesImpl(long waitTimeMs, int count) throws InterruptedException {
        long start = System.currentTimeMillis();
        while (this.payloads.size() < count) {
            this.wait(waitTimeMs + 500L);
            if (this.payloads.size() >= count) {
                return this.payloads;
            }
            long time = System.currentTimeMillis() - start;
            if (time <= waitTimeMs) continue;
            throw new IllegalStateException("While waiting for " + count + " responses, some or all never came.  count that came=" + this.payloads.size());
        }
        return this.payloads;
    }

    public void clear() {
        this.payloads.clear();
        this.chunkedResponse = null;
    }
}

