/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import com.google.inject.Module;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLEngine;
import org.webpieces.httpclient11.api.HttpClient;
import org.webpieces.httpclient11.api.HttpClientFactory;
import org.webpieces.httpclient11.api.HttpSocket;
import org.webpieces.mock.time.MockTime;
import org.webpieces.mock.time.MockTimer;
import org.webpieces.nio.api.BackpressureConfig;
import org.webpieces.webserver.test.MockChannelManager;
import org.webpieces.webserver.test.OverridesForTest;
import org.webpieces.webserver.test.OverridesForTestRealServer;
import org.webpieces.webserver.test.http11.DirectHttp11Client;

public class AbstractWebpiecesTest {
    protected MockChannelManager mgr = new MockChannelManager();
    protected MockTime time = new MockTime(true);
    protected MockTimer mockTimer = new MockTimer();

    public HttpSocket connectHttp(boolean isRemote, InetSocketAddress addr) throws InterruptedException, ExecutionException, TimeoutException {
        HttpSocket socket = this.getClient(isRemote).createHttpSocket();
        CompletableFuture connect = socket.connect(addr);
        connect.get(2L, TimeUnit.SECONDS);
        return socket;
    }

    public HttpSocket connectHttps(boolean isRemote, SSLEngine engine, InetSocketAddress addr) throws InterruptedException, ExecutionException, TimeoutException {
        HttpSocket socket = this.getClient(isRemote).createHttpsSocket(engine);
        CompletableFuture connect = socket.connect(addr);
        connect.get(2L, TimeUnit.SECONDS);
        return socket;
    }

    protected Module getOverrides(boolean isFullServer) {
        if (isFullServer) {
            return new OverridesForTestRealServer();
        }
        return new OverridesForTest(this.mgr, this.time, this.mockTimer);
    }

    protected HttpClient getClient(boolean isRemote) {
        if (isRemote) {
            HttpClient client = HttpClientFactory.createHttpClient((String)"testClient", (int)5, (BackpressureConfig)new BackpressureConfig());
            return client;
        }
        return new DirectHttp11Client(this.mgr);
    }
}

