/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test;

import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Named;
import javax.inject.Singleton;
import org.webpieces.mock.time.MockTime;
import org.webpieces.mock.time.MockTimer;
import org.webpieces.nio.api.ChannelManager;
import org.webpieces.templatingdev.api.DevTemplateModule;
import org.webpieces.templatingdev.api.TemplateCompileConfig;
import org.webpieces.util.logging.Logger;
import org.webpieces.util.logging.LoggerFactory;
import org.webpieces.util.threading.DirectExecutorService;
import org.webpieces.util.time.Time;
import org.webpieces.webserver.test.MockChannelManager;

public class OverridesForTest
implements Module {
    private static final Logger log = LoggerFactory.getLogger(OverridesForTest.class);
    private TemplateCompileConfig templateConfig;
    private MockChannelManager mgr;
    private MockTime time;
    private MockTimer mockTimer;

    public OverridesForTest(MockChannelManager mgr, MockTime time, MockTimer mockTimer) {
        this(mgr, time, mockTimer, new TemplateCompileConfig(OverridesForTest.isGradleRunning()));
    }

    public OverridesForTest(MockChannelManager mgr, MockTime time, MockTimer mockTimer, TemplateCompileConfig config) {
        this.mgr = mgr;
        this.time = time;
        this.mockTimer = mockTimer;
        this.templateConfig = config;
    }

    public void configure(Binder binder) {
        binder.bind(ChannelManager.class).toInstance((Object)this.mgr);
        binder.bind(Time.class).toInstance((Object)this.time);
        binder.bind(ScheduledExecutorService.class).toInstance((Object)this.mockTimer);
        binder.install((Module)new DevTemplateModule(this.templateConfig));
    }

    @Provides
    @Singleton
    @Named(value="fileReadExecutor")
    public ExecutorService provideExecutor() {
        return new DirectExecutorService();
    }

    @Provides
    @Singleton
    @Named(value="http2EngineThreadPool")
    public Executor providesEngineThreadPool() {
        return new DirectExecutorService();
    }

    public static boolean isGradleRunning() {
        String property = System.getProperty("gradle.running");
        if ("true".equals(property)) {
            log.info("gradle running.  using class files from filesystem");
            return true;
        }
        log.info("gradle NOT running.  generating groovy class files for test so test doesn't fail with class not found in IDE ever");
        return false;
    }
}

