/*
 * Decompiled with CFR 0.152.
 */
package org.webpieces.webserver.test.http11;

import javax.net.ssl.SSLEngine;
import org.webpieces.data.api.BufferCreationPool;
import org.webpieces.data.api.BufferPool;
import org.webpieces.httpclient11.api.HttpClient;
import org.webpieces.httpclient11.api.HttpSocket;
import org.webpieces.httpclient11.impl.ChannelProxy;
import org.webpieces.httpclient11.impl.HttpSocketImpl;
import org.webpieces.httpparser.api.HttpParser;
import org.webpieces.httpparser.api.HttpParserFactory;
import org.webpieces.nio.api.handlers.ConnectionListener;
import org.webpieces.webserver.test.MockChannelManager;
import org.webpieces.webserver.test.MockTcpChannel;
import org.webpieces.webserver.test.http11.DelayedProxy;

public class DirectHttp11Client
implements HttpClient {
    private MockChannelManager mgr;
    private HttpParser parser = HttpParserFactory.createParser((BufferPool)new BufferCreationPool());

    public DirectHttp11Client(MockChannelManager mgr) {
        this.mgr = mgr;
    }

    public HttpSocket createHttpSocket() {
        ConnectionListener listener = this.mgr.getHttpConnection();
        MockTcpChannel channel = new MockTcpChannel();
        try {
            return new HttpSocketImpl((ChannelProxy)new DelayedProxy(listener, channel), this.parser);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public HttpSocket createHttpsSocket(SSLEngine engine) {
        ConnectionListener listener = this.mgr.getHttpsConnection();
        MockTcpChannel channel = new MockTcpChannel();
        try {
            return new HttpSocketImpl((ChannelProxy)new DelayedProxy(listener, channel), this.parser);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }
}

