/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.hpack.impl;

import com.twitter.hpack.Decoder;
import com.webpieces.hpack.api.UnmarshalState;
import com.webpieces.hpack.impl.HeaderDecoding;
import com.webpieces.http2parser.api.Http2Memento;
import com.webpieces.http2parser.api.dto.lib.HasHeaderFragment;
import com.webpieces.http2parser.api.dto.lib.Http2Msg;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class UnmarshalStateImpl
implements UnmarshalState {
    private HeaderDecoding decoding;
    private Decoder decoder;
    private Http2Memento lowLevelState;
    private List<HasHeaderFragment> headersToCombine = new LinkedList<HasHeaderFragment>();
    private List<Http2Msg> parsedFrames = new ArrayList<Http2Msg>();
    private String logId;
    private int numBytesJustParsed = 0;
    private int dataToParseSize = 0;
    private int halfParsedSize;

    public UnmarshalStateImpl(String logId, Http2Memento lowLevelState, HeaderDecoding decoding, Decoder decoder) {
        this.logId = logId;
        this.lowLevelState = lowLevelState;
        this.decoding = decoding;
        this.decoder = decoder;
    }

    @Override
    public List<Http2Msg> getParsedFrames() {
        return this.parsedFrames;
    }

    public Http2Memento getLowLevelState() {
        return this.lowLevelState;
    }

    public List<HasHeaderFragment> getHeadersToCombine() {
        return this.headersToCombine;
    }

    public Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public void setDecoderMaxTableSize(int newSize) {
        this.decoding.setMaxHeaderTableSize(this.decoder, newSize);
    }

    @Override
    public void setIncomingMaxFrameSize(long maxFrameSize) {
        this.lowLevelState.setIncomingMaxFrameSize(maxFrameSize);
    }

    public void clearParsedFrames() {
        this.parsedFrames = new ArrayList<Http2Msg>();
    }

    public String getLogId() {
        return this.logId;
    }

    @Override
    public int getLeftOverDataSize() {
        return this.dataToParseSize;
    }

    @Override
    public int getNumBytesJustParsed() {
        return this.numBytesJustParsed;
    }

    public int getDataToParseSize() {
        return this.dataToParseSize;
    }

    public void addToDataToParseSize(int readableSize) {
        this.dataToParseSize += readableSize;
    }

    public void addHalfParsedSize(int numBytesJustParsed2) {
        this.halfParsedSize += numBytesJustParsed2;
    }

    public void addParsedMessage(Http2Msg frame) {
        this.numBytesJustParsed += this.halfParsedSize;
        this.dataToParseSize -= this.halfParsedSize;
        this.parsedFrames.add(frame);
        this.halfParsedSize = 0;
    }

    public void resetNumBytesJustParsed() {
        this.numBytesJustParsed = 0;
    }
}

