/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.dto.Http2Frame;
import com.webpieces.http2parser.api.dto.Http2WindowUpdate;
import com.webpieces.http2parser.impl.FrameMarshallerImpl;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class WindowUpdateMarshaller
extends FrameMarshallerImpl {
    WindowUpdateMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool, dataGen);
    }

    @Override
    public byte marshalFlags(Http2Frame frame) {
        return 0;
    }

    @Override
    public DataWrapper marshalPayload(Http2Frame frame) {
        Http2WindowUpdate castFrame = (Http2WindowUpdate)frame;
        ByteBuffer payload = this.bufferPool.nextBuffer(4).putInt(castFrame.getWindowSizeIncrement());
        payload.flip();
        return this.dataGen.wrapByteBuffer(payload);
    }

    @Override
    public void unmarshalFlagsAndPayload(Http2Frame frame, byte flags, Optional<DataWrapper> maybePayload) {
        Http2WindowUpdate castFrame = (Http2WindowUpdate)frame;
        maybePayload.ifPresent(payload -> {
            ByteBuffer payloadByteBuffer = this.bufferPool.createWithDataWrapper(payload);
            castFrame.setWindowSizeIncrement(payloadByteBuffer.getInt());
            this.bufferPool.releaseBuffer(payloadByteBuffer);
        });
    }
}

