/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.twitter.hpack.Decoder;
import com.twitter.hpack.Encoder;
import com.webpieces.http2parser.api.FrameMarshaller;
import com.webpieces.http2parser.api.Http2Parser;
import com.webpieces.http2parser.api.Http2SettingsMap;
import com.webpieces.http2parser.api.ParseException;
import com.webpieces.http2parser.api.ParserResult;
import com.webpieces.http2parser.api.dto.HasHeaderFragment;
import com.webpieces.http2parser.api.dto.HasHeaderList;
import com.webpieces.http2parser.api.dto.Http2Continuation;
import com.webpieces.http2parser.api.dto.Http2Data;
import com.webpieces.http2parser.api.dto.Http2ErrorCode;
import com.webpieces.http2parser.api.dto.Http2Frame;
import com.webpieces.http2parser.api.dto.Http2FrameType;
import com.webpieces.http2parser.api.dto.Http2GoAway;
import com.webpieces.http2parser.api.dto.Http2Headers;
import com.webpieces.http2parser.api.dto.Http2Ping;
import com.webpieces.http2parser.api.dto.Http2Priority;
import com.webpieces.http2parser.api.dto.Http2PushPromise;
import com.webpieces.http2parser.api.dto.Http2RstStream;
import com.webpieces.http2parser.api.dto.Http2Settings;
import com.webpieces.http2parser.api.dto.Http2WindowUpdate;
import com.webpieces.http2parser.impl.ContinuationMarshaller;
import com.webpieces.http2parser.impl.DataMarshaller;
import com.webpieces.http2parser.impl.GoAwayMarshaller;
import com.webpieces.http2parser.impl.HeadersMarshaller;
import com.webpieces.http2parser.impl.ParserResultImpl;
import com.webpieces.http2parser.impl.PingMarshaller;
import com.webpieces.http2parser.impl.PriorityMarshaller;
import com.webpieces.http2parser.impl.PushPromiseMarshaller;
import com.webpieces.http2parser.impl.RstStreamMarshaller;
import com.webpieces.http2parser.impl.SettingsMarshaller;
import com.webpieces.http2parser.impl.WindowUpdateMarshaller;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;

public class Http2ParserImpl
implements Http2Parser {
    private final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();
    private static final Logger log = LoggerFactory.getLogger(Http2ParserImpl.class);
    private final BufferPool bufferPool;
    private final Map<Class<? extends Http2Frame>, FrameMarshaller> dtoToMarshaller = new HashMap<Class<? extends Http2Frame>, FrameMarshaller>();
    private static Map<Http2FrameType, Integer> fixedFrameLengthByType = new HashMap<Http2FrameType, Integer>();
    private static List<Http2FrameType> connectionLevelFrames = new ArrayList<Http2FrameType>();

    public Http2ParserImpl(BufferPool bufferPool) {
        this.bufferPool = bufferPool;
        this.dtoToMarshaller.put(Http2Data.class, new DataMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2Headers.class, new HeadersMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2Priority.class, new PriorityMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2RstStream.class, new RstStreamMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2Settings.class, new SettingsMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2PushPromise.class, new PushPromiseMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2Ping.class, new PingMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2GoAway.class, new GoAwayMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2WindowUpdate.class, new WindowUpdateMarshaller(bufferPool, this.dataGen));
        this.dtoToMarshaller.put(Http2Continuation.class, new ContinuationMarshaller(bufferPool, this.dataGen));
    }

    @Override
    public FrameMarshaller getMarshaller(Class<? extends Http2Frame> frameClass) {
        return this.dtoToMarshaller.get(frameClass);
    }

    @Override
    public DataWrapper prepareToParse() {
        return this.dataGen.emptyWrapper();
    }

    private int peekLengthOfFrame(DataWrapper data) {
        ByteBuffer lengthBytes = ByteBuffer.wrap(data.readBytesAt(0, 3));
        int length = lengthBytes.getShort() << 8;
        return (length |= lengthBytes.get()) + 9;
    }

    private Class<? extends Http2Frame> getFrameClassForType(Http2FrameType type) {
        switch (type) {
            case DATA: {
                return Http2Data.class;
            }
            case HEADERS: {
                return Http2Headers.class;
            }
            case PRIORITY: {
                return Http2Priority.class;
            }
            case RST_STREAM: {
                return Http2RstStream.class;
            }
            case SETTINGS: {
                return Http2Settings.class;
            }
            case PUSH_PROMISE: {
                return Http2PushPromise.class;
            }
            case PING: {
                return Http2Ping.class;
            }
            case GOAWAY: {
                return Http2GoAway.class;
            }
            case WINDOW_UPDATE: {
                return Http2WindowUpdate.class;
            }
            case CONTINUATION: {
                return Http2Continuation.class;
            }
        }
        return Http2Data.class;
    }

    private int getLength(DataWrapper data) {
        ByteBuffer headerByteBuffer = this.bufferPool.nextBuffer(9);
        headerByteBuffer.put(data.readBytesAt(0, 9));
        headerByteBuffer.flip();
        return headerByteBuffer.getInt() >>> 8;
    }

    private byte getFrameTypeId(DataWrapper data) {
        return data.readByteAt(3);
    }

    private byte getFlagsByte(DataWrapper data) {
        return data.readByteAt(4);
    }

    private int getStreamId(DataWrapper data) {
        ByteBuffer streamIdBuffer = this.bufferPool.nextBuffer(4);
        streamIdBuffer.put(data.readBytesAt(5, 4));
        streamIdBuffer.flip();
        return streamIdBuffer.getInt() & Integer.MAX_VALUE;
    }

    @Override
    public Http2Frame unmarshal(DataWrapper data) {
        int length = this.getLength(data);
        byte frameTypeId = this.getFrameTypeId(data);
        byte flagsByte = this.getFlagsByte(data);
        int streamId = this.getStreamId(data);
        Http2FrameType frameType = Http2FrameType.fromId(frameTypeId).get();
        Class<? extends Http2Frame> frameClass = this.getFrameClassForType(frameType);
        try {
            Optional<Object> maybePayload;
            Http2Frame frame = frameClass.newInstance();
            FrameMarshaller marshaller = this.dtoToMarshaller.get(frameClass);
            frame.setStreamId(streamId);
            if (length > 0) {
                List splitWrappers = this.dataGen.split(data, 9);
                DataWrapper payloadPlusMore = (DataWrapper)splitWrappers.get(1);
                List split = this.dataGen.split(payloadPlusMore, length);
                maybePayload = Optional.of(split.get(0));
            } else {
                maybePayload = Optional.empty();
            }
            marshaller.unmarshalFlagsAndPayload(frame, flagsByte, maybePayload);
            return frame;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    private byte getFrameTypeByte(Http2Frame frame) {
        return frame.getFrameType().getId();
    }

    @Override
    public int getFrameLength(Http2Frame frame) {
        FrameMarshaller marshaller = this.dtoToMarshaller.get(frame.getClass());
        DataWrapper payload = marshaller.marshalPayload(frame);
        return payload.getReadableSize();
    }

    @Override
    public DataWrapper marshal(Http2Frame frame) {
        FrameMarshaller marshaller = this.dtoToMarshaller.get(frame.getClass());
        if (marshaller == null) {
            return null;
        }
        ByteBuffer header = ByteBuffer.allocate(9);
        DataWrapper payload = marshaller.marshalPayload(frame);
        int length = payload.getReadableSize();
        header.put((byte)(length >>> 16));
        header.putShort((short)length);
        header.put(this.getFrameTypeByte(frame));
        header.put(marshaller.marshalFlags(frame));
        header.putInt(frame.getStreamId());
        header.flip();
        return this.dataGen.chainDataWrappers(this.dataGen.wrapByteBuffer(header), payload);
    }

    @Override
    public DataWrapper marshal(List<Http2Frame> frames) {
        DataWrapper data = this.dataGen.emptyWrapper();
        for (Http2Frame frame : frames) {
            data = this.dataGen.chainDataWrappers(data, this.marshal(frame));
        }
        return data;
    }

    @Override
    public ParserResult parse(DataWrapper oldData, DataWrapper newData, Decoder decoder, Http2SettingsMap settings) {
        LinkedList<Http2Frame> frames = new LinkedList<Http2Frame>();
        LinkedList<Http2Frame> hasHeaderFragmentList = new LinkedList<Http2Frame>();
        DataWrapper wrapperToParse = oldData.getReadableSize() > 0 ? this.dataGen.chainDataWrappers(oldData, newData) : newData;
        DataWrapper wrapperToReturn = wrapperToParse;
        int lengthOfData;
        while ((lengthOfData = wrapperToParse.getReadableSize()) >= 9) {
            int payloadLength = this.getLength(wrapperToParse);
            int streamId = this.getStreamId(wrapperToParse);
            Optional<Http2FrameType> maybeFrameType = Http2FrameType.fromId(this.getFrameTypeId(wrapperToParse));
            maybeFrameType.ifPresent(frameType -> {
                Integer fixedLengthForType = fixedFrameLengthByType.get(frameType);
                if ((long)payloadLength > (Long)settings.get((Object)Http2Settings.Parameter.SETTINGS_MAX_FRAME_SIZE) || fixedLengthForType != null && payloadLength != fixedLengthForType || frameType == Http2FrameType.SETTINGS && payloadLength % 6 != 0) {
                    boolean isConnectionLevel = connectionLevelFrames.contains(frameType) || streamId == 0;
                    throw new ParseException(Http2ErrorCode.FRAME_SIZE_ERROR, streamId, isConnectionLevel);
                }
            });
            if (!maybeFrameType.isPresent() && !hasHeaderFragmentList.isEmpty()) {
                throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR);
            }
            int totalLength = payloadLength + 9;
            if (lengthOfData < totalLength) {
                return new ParserResultImpl(frames, wrapperToReturn);
            }
            List split = this.dataGen.split(wrapperToParse, totalLength);
            if (maybeFrameType.isPresent()) {
                Http2FrameType frameType2 = maybeFrameType.get();
                Http2Frame frame = this.unmarshal((DataWrapper)split.get(0));
                if (!hasHeaderFragmentList.isEmpty()) {
                    this.checkForBadFrames(hasHeaderFragmentList, frameType2, frame);
                }
                if (Arrays.asList(Http2FrameType.HEADERS, Http2FrameType.PUSH_PROMISE, Http2FrameType.CONTINUATION).contains((Object)frameType2)) {
                    if (frameType2 == Http2FrameType.CONTINUATION && hasHeaderFragmentList.isEmpty()) {
                        throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR, frame.getStreamId(), true);
                    }
                    hasHeaderFragmentList.add(frame);
                    if (((HasHeaderFragment)((Object)frame)).isEndHeaders()) {
                        this.doSomething(decoder, frames, hasHeaderFragmentList);
                        wrapperToReturn = wrapperToParse = (DataWrapper)split.get(1);
                        continue;
                    }
                    wrapperToParse = (DataWrapper)split.get(1);
                    continue;
                }
                frames.add(frame);
                wrapperToReturn = wrapperToParse = (DataWrapper)split.get(1);
                continue;
            }
            wrapperToReturn = wrapperToParse = (DataWrapper)split.get(1);
        }
        return new ParserResultImpl(frames, wrapperToReturn);
    }

    private void doSomething(Decoder decoder, List<Http2Frame> frames, List<Http2Frame> hasHeaderFragmentList) {
        Http2Frame firstFrame = hasHeaderFragmentList.get(0);
        DataWrapper allSerializedHeaders = this.dataGen.emptyWrapper();
        for (Http2Frame iterFrame : hasHeaderFragmentList) {
            allSerializedHeaders = this.dataGen.chainDataWrappers(allSerializedHeaders, ((HasHeaderFragment)((Object)iterFrame)).getHeaderFragment());
        }
        ((HasHeaderList)((Object)firstFrame)).setHeaderList(this.deserializeHeaders(allSerializedHeaders, decoder));
        ((HasHeaderFragment)((Object)firstFrame)).setEndHeaders(true);
        frames.add(firstFrame);
        hasHeaderFragmentList.clear();
    }

    private void checkForBadFrames(List<Http2Frame> hasHeaderFragmentList, Http2FrameType frameType, Http2Frame frame) {
        if (frameType != Http2FrameType.CONTINUATION) {
            throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR);
        }
        switch (hasHeaderFragmentList.get(0).getFrameType()) {
            case PUSH_PROMISE: {
                if (frame.getStreamId() == ((Http2PushPromise)hasHeaderFragmentList.get(0)).getPromisedStreamId()) break;
                throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR);
            }
            case HEADERS: {
                if (frame.getStreamId() == hasHeaderFragmentList.get(0).getStreamId()) break;
                throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR);
            }
            default: {
                throw new ParseException(Http2ErrorCode.INTERNAL_ERROR);
            }
        }
    }

    @Override
    public DataWrapper serializeHeaders(LinkedList<HasHeaderFragment.Header> headers, Encoder encoder, ByteArrayOutputStream out) {
        for (HasHeaderFragment.Header header : headers) {
            try {
                encoder.encodeHeader((OutputStream)out, header.header.toLowerCase().getBytes(), header.value.getBytes(), false);
            }
            catch (IOException iOException) {}
        }
        return this.dataGen.wrapByteArray(out.toByteArray());
    }

    @Override
    public List<Http2Frame> createHeaderFrames(LinkedList<HasHeaderFragment.Header> headers, Http2FrameType startingFrameType, int streamId, Http2SettingsMap remoteSettings, Encoder encoder, ByteArrayOutputStream out) {
        LinkedList<Http2Frame> headerFrames = new LinkedList<Http2Frame>();
        DataWrapper serializedHeaders = this.serializeHeaders(headers, encoder, out);
        long maxFrameSize = (Long)remoteSettings.get((Object)Http2Settings.Parameter.SETTINGS_MAX_FRAME_SIZE) - 16L;
        boolean firstFrame = true;
        boolean lastFrame = false;
        try {
            Http2Frame frame;
            while (true) {
                DataWrapper fragment;
                if ((long)serializedHeaders.getReadableSize() <= maxFrameSize) {
                    lastFrame = true;
                    fragment = serializedHeaders;
                } else {
                    List split = this.dataGen.split(serializedHeaders, (int)maxFrameSize);
                    fragment = (DataWrapper)split.get(0);
                    serializedHeaders = (DataWrapper)split.get(1);
                }
                if (firstFrame) {
                    frame = this.getFrameClassForType(startingFrameType).newInstance();
                    if (frame.getFrameType() == Http2FrameType.PUSH_PROMISE) {
                        ((Http2PushPromise)frame).setPromisedStreamId(streamId);
                    } else {
                        frame.setStreamId(streamId);
                    }
                } else {
                    frame = new Http2Continuation();
                    frame.setStreamId(streamId);
                }
                ((HasHeaderFragment)((Object)frame)).setHeaderFragment(fragment);
                headerFrames.add(frame);
                if (lastFrame) break;
                firstFrame = false;
            }
            ((HasHeaderFragment)((Object)frame)).setEndHeaders(true);
            return headerFrames;
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    @Override
    public LinkedList<HasHeaderFragment.Header> deserializeHeaders(DataWrapper data, Decoder decoder) {
        LinkedList<HasHeaderFragment.Header> headers = new LinkedList<HasHeaderFragment.Header>();
        byte[] bytes = data.createByteArray();
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            decoder.decode((InputStream)in, (name, value, sensitive) -> {
                String h = new String(name);
                String v = new String(value);
                if (!h.equals(h.toLowerCase())) {
                    throw new ParseException(Http2ErrorCode.PROTOCOL_ERROR);
                }
                headers.add(new HasHeaderFragment.Header(h, v));
            });
        }
        catch (IOException e) {
            throw new ParseException(Http2ErrorCode.COMPRESSION_ERROR);
        }
        decoder.endHeaderBlock();
        return headers;
    }

    static {
        fixedFrameLengthByType.put(Http2FrameType.PRIORITY, 5);
        fixedFrameLengthByType.put(Http2FrameType.RST_STREAM, 4);
        fixedFrameLengthByType.put(Http2FrameType.PING, 8);
        fixedFrameLengthByType.put(Http2FrameType.WINDOW_UPDATE, 4);
        connectionLevelFrames.add(Http2FrameType.SETTINGS);
        connectionLevelFrames.add(Http2FrameType.CONTINUATION);
        connectionLevelFrames.add(Http2FrameType.HEADERS);
        connectionLevelFrames.add(Http2FrameType.PUSH_PROMISE);
        connectionLevelFrames.add(Http2FrameType.RST_STREAM);
        connectionLevelFrames.add(Http2FrameType.WINDOW_UPDATE);
    }
}

