/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.Http2SettingsMap;
import com.webpieces.http2parser.api.dto.Http2Frame;
import com.webpieces.http2parser.api.dto.Http2Settings;
import com.webpieces.http2parser.impl.FrameMarshallerImpl;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Optional;
import org.webpieces.data.api.BufferPool;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;

public class SettingsMarshaller
extends FrameMarshallerImpl {
    SettingsMarshaller(BufferPool bufferPool, DataWrapperGenerator dataGen) {
        super(bufferPool, dataGen);
    }

    @Override
    public DataWrapper marshalPayload(Http2Frame frame) {
        Http2Settings castFrame = (Http2Settings)frame;
        if (castFrame.isAck() || castFrame.getSettings().size() == 0) {
            return this.dataGen.emptyWrapper();
        }
        Http2SettingsMap settings = castFrame.getSettings();
        ByteBuffer payload = this.bufferPool.nextBuffer(6 * settings.size());
        for (Map.Entry setting : settings.entrySet()) {
            short id = ((Http2Settings.Parameter)((Object)setting.getKey())).getId();
            Long value = (Long)setting.getValue();
            payload.putShort(id).putInt(value.intValue());
        }
        payload.flip();
        return this.dataGen.wrapByteBuffer(payload);
    }

    @Override
    public byte marshalFlags(Http2Frame frame) {
        Http2Settings castFrame = (Http2Settings)frame;
        byte value = 0;
        if (castFrame.isAck()) {
            value = (byte)(value | 1);
        }
        return value;
    }

    @Override
    public void unmarshalFlagsAndPayload(Http2Frame frame, byte flags, Optional<DataWrapper> maybePayload) {
        Http2Settings castFrame = (Http2Settings)frame;
        castFrame.setAck((flags & 1) == 1);
        maybePayload.ifPresent(payload -> {
            ByteBuffer payloadByteBuffer = this.bufferPool.createWithDataWrapper(payload);
            while (payloadByteBuffer.hasRemaining()) {
                castFrame.setSetting(Http2Settings.Parameter.fromId(payloadByteBuffer.getShort()), (long)payloadByteBuffer.getInt() & 0xFFFFFFFFL);
            }
            this.bufferPool.releaseBuffer(payloadByteBuffer);
        });
    }
}

