/*
 * Decompiled with CFR 0.152.
 */
package com.webpieces.http2parser.impl;

import com.webpieces.http2parser.api.ConnectionException;
import com.webpieces.http2parser.api.ParseFailReason;
import com.webpieces.http2parser.impl.DataSplit;
import java.util.List;
import org.webpieces.data.api.DataWrapper;
import org.webpieces.data.api.DataWrapperGenerator;
import org.webpieces.data.api.DataWrapperGeneratorFactory;

public class PaddingUtil {
    private static final DataWrapperGenerator dataGen = DataWrapperGeneratorFactory.createDataWrapperGenerator();

    public static DataSplit extractPayloadAndPadding(boolean isPadded, DataWrapper data, int streamId) {
        if (!isPadded) {
            return new DataSplit(data, DataWrapperGeneratorFactory.EMPTY);
        }
        short padLength = (short)(data.readByteAt(0) & 0xFF);
        if (padLength > data.getReadableSize()) {
            throw new ConnectionException(ParseFailReason.NOT_ENOUGH_PAD_DATA, streamId, "expected padLenth of=" + padLength + " but only found=" + data.getReadableSize());
        }
        List split1 = dataGen.split(data, 1);
        List split2 = dataGen.split((DataWrapper)split1.get(1), ((DataWrapper)split1.get(1)).getReadableSize() - padLength);
        return new DataSplit((DataWrapper)split2.get(0), (DataWrapper)split2.get(1));
    }

    public static DataWrapper padDataIfNeeded(DataWrapper data, DataWrapper padding) {
        if (padding.getReadableSize() > 0) {
            byte[] length = new byte[]{(byte)padding.getReadableSize()};
            DataWrapper lengthDW = dataGen.wrapByteArray(length);
            return dataGen.chainDataWrappers(dataGen.chainDataWrappers(lengthDW, data), padding);
        }
        return data;
    }
}

