/*
 * Decompiled with CFR 0.152.
 */
package org.boris.pecoff4j.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.boris.pecoff4j.PE;
import org.boris.pecoff4j.ResourceDirectory;
import org.boris.pecoff4j.ResourceEntry;
import org.boris.pecoff4j.io.DataReader;
import org.boris.pecoff4j.io.DataWriter;
import org.boris.pecoff4j.io.PEParser;
import org.boris.pecoff4j.io.ResourceParser;
import org.boris.pecoff4j.resources.GroupIconDirectory;
import org.boris.pecoff4j.resources.GroupIconDirectoryEntry;
import org.boris.pecoff4j.resources.IconDirectory;
import org.boris.pecoff4j.resources.IconDirectoryEntry;
import org.boris.pecoff4j.resources.IconImage;
import org.boris.pecoff4j.util.IconFile;
import org.boris.pecoff4j.util.ResourceHelper;

public class IconExtractor {
    public static void extract(File pecoff, File outputDir) throws IOException {
        PE pe = PEParser.parse(pecoff);
        ResourceDirectory rd = pe.getImageData().getResourceTable();
        if (rd == null) {
            return;
        }
        ResourceEntry[] entries = ResourceHelper.findResources(rd, 14);
        for (int i = 0; i < entries.length; ++i) {
            GroupIconDirectory gid = GroupIconDirectory.read(entries[i].getData());
            IconFile icf = new IconFile();
            IconDirectory icd = new IconDirectory();
            icd.setType(1);
            icd.setReserved(0);
            icf.setDirectory(icd);
            IconImage[] images = new IconImage[gid.getCount()];
            icf.setImages(images);
            for (int j = 0; j < gid.getCount(); ++j) {
                IconImage ii;
                GroupIconDirectoryEntry gide = gid.getEntry(j);
                IconDirectoryEntry ide = new IconDirectoryEntry();
                ide.copyFrom(gide);
                icd.add(ide);
                ResourceEntry[] icos = ResourceHelper.findResources(rd, 3, gide.getId());
                if (icos == null || icos.length != 1) {
                    throw new IOException("Unexpected icons in resource file");
                }
                byte[] d = icos[0].getData();
                ide.setBytesInRes(d.length);
                images[j] = gide.getWidth() == 0 && gide.getHeight() == 0 ? (ii = ResourceParser.readPNG(d)) : (ii = ResourceParser.readIconImage(new DataReader(d), gide.getBytesInRes()));
            }
            File outFile = new File(outputDir, pecoff.getName() + "-icon" + i + ".ico");
            DataWriter dw = new DataWriter(new FileOutputStream(outFile));
            icf.write(dw);
            dw.close();
        }
    }
}

