/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.mount.core;

import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.IRequestMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wicketstuff.wicket.mount.core.MountInfo;

public class AutoMounter {
    private static final Logger LOG = LoggerFactory.getLogger(AutoMounter.class);

    public static boolean mountAll(WebApplication app) {
        String mapInfoClassName = app.getClass().getCanonicalName() + "MountInfo";
        try {
            MountInfo mountInfo = (MountInfo)WicketObjects.newInstance((String)mapInfoClassName);
            for (IRequestMapper mapper : mountInfo.getMountList()) {
                app.mount(mapper);
            }
            return true;
        }
        catch (Exception ex) {
            LOG.warn("Failed to automount pages.", (Throwable)ex);
            return false;
        }
    }
}

