/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.mount.core.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.Map;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementScanner6;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.wicketstuff.wicket.mount.core.annotation.MountPath;
import org.wicketstuff.wicket.mount.core.processor.AutoMountContext;

public abstract class AbstractAutoMountAnnotationProcessor
extends AbstractProcessor {
    private TypeElement pageElement;
    private TypeElement applicationElement;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.pageElement = processingEnv.getElementUtils().getTypeElement("org.apache.wicket.Page");
        this.applicationElement = processingEnv.getElementUtils().getTypeElement("org.apache.wicket.Application");
    }

    private boolean isValidApplicationType(TypeElement typeElement) {
        return this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), this.applicationElement.asType());
    }

    protected AutoMountContext getAutoMountContext(Element autoMountElement, Class<? extends Annotation> annotationClass) {
        Annotation autoMount = autoMountElement.getAnnotation(annotationClass);
        if (autoMount == null) {
            return null;
        }
        if (autoMountElement.getKind() != ElementKind.CLASS) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "The " + autoMount.annotationType() + " should only support ElementType.TYPE.");
            return null;
        }
        TypeElement classElement = (TypeElement)autoMountElement;
        if (!this.isValidApplicationType(classElement)) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Automounting will not be processed for class " + classElement.getQualifiedName().toString() + " because it is not a subclass of " + this.applicationElement.getQualifiedName());
            return null;
        }
        AutoMountContext context = new AutoMountContext(classElement);
        this.setPackagesToScan(context);
        return context;
    }

    protected abstract void setPackagesToScan(AutoMountContext var1);

    protected void processMountPoint(AutoMountContext context, Element elem, Annotation annotation) {
        TypeElement classElement;
        final String customMount = this.extractMountPath(context, annotation);
        if (elem.getKind() == ElementKind.CLASS && this.isValidPageType(classElement = (TypeElement)elem, context.getPackagesToScan())) {
            if (!customMount.contains("*") && context.containsMountPoint(customMount)) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Multiple mount points exist for " + customMount);
            }
            context.setMountPoint(classElement, customMount);
        }
        if (elem.getKind() == ElementKind.PACKAGE) {
            ElementScanner6<Void, AutoMountContext> scanner = new ElementScanner6<Void, AutoMountContext>(){

                @Override
                public Void visitType(TypeElement typeElement, AutoMountContext context) {
                    if (AbstractAutoMountAnnotationProcessor.this.isValidPageType(typeElement, context.getPackagesToScan())) {
                        if (!customMount.contains("*")) {
                            context.setMountPoint(typeElement, customMount + "/*");
                        } else {
                            context.setMountPoint(typeElement, customMount);
                        }
                    }
                    return (Void)super.visitType(typeElement, context);
                }
            };
            elem.accept(scanner, context);
        }
    }

    protected abstract String getDefaultRootPath(AutoMountContext var1, TypeElement var2);

    protected abstract String getDefaultMimeExtension(AutoMountContext var1, TypeElement var2);

    protected String extractMountPath(AutoMountContext context, Annotation annotation) {
        String path = "/*";
        if (annotation instanceof MountPath) {
            path = ((MountPath)annotation).value();
        }
        return path.replaceAll("/+$", "");
    }

    private boolean isValidPageType(TypeElement typeElement, String[] validPackages) {
        for (String validPkgName : validPackages) {
            String pkgName = ((PackageElement)typeElement.getEnclosingElement()).getQualifiedName().toString();
            boolean existsInValidPackage = validPkgName.endsWith(".*") ? pkgName.startsWith(validPkgName.substring(0, validPkgName.length() - 2)) : pkgName.equals(validPkgName);
            if (!existsInValidPackage) continue;
            boolean extendsPage = this.processingEnv.getTypeUtils().isAssignable(typeElement.asType(), this.pageElement.asType());
            return extendsPage &= !typeElement.getModifiers().contains((Object)Modifier.ABSTRACT);
        }
        return false;
    }

    protected String generateGenericName(AutoMountContext context, TypeElement elem, String path) {
        if (path == null || path.trim().isEmpty()) {
            path = "/*";
        }
        if (!(path = path.trim()).endsWith("/*")) {
            return path;
        }
        String root = "/*".equals(path) ? this.getDefaultRootPath(context, elem) : path.substring(0, path.length() - 2);
        String elemName = elem.getSimpleName().toString();
        String mimeExtension = this.getDefaultMimeExtension(context, elem);
        String genericName = root + "/" + elemName + mimeExtension;
        int i = 1;
        while (context.containsMountPoint(genericName) && i < Integer.MAX_VALUE) {
            genericName = root + "/" + elemName + "_" + i++ + mimeExtension;
        }
        return genericName;
    }

    protected void completeAbstractMountPoints(AutoMountContext context) {
        for (TypeElement elem : context.getMountableElements()) {
            String mp = context.getMountPoint(elem);
            if (mp.matches("(.)*\\*(.)*\\*")) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "MountPoint set for " + elem.getQualifiedName().toString() + " can only contain at most 1 wildcard(*). MountPoint is set to " + mp);
            }
            if (mp.endsWith("/*")) {
                String genericName = this.generateGenericName(context, elem, mp);
                context.setMountPoint(elem, genericName);
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Generating generic Mount Point for " + elem.getQualifiedName() + ". Original Mount point set to " + mp + ". New Mount point is " + context.getMountPoint(elem));
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Using set Mount Point for " + elem.getQualifiedName() + ". Mount point is " + context.getMountPoint(elem));
        }
    }

    protected void generateSource(AutoMountContext context) throws IOException {
        this.completeAbstractMountPoints(context);
        String infoClassName = context.getApplicationClassTypeElement().getSimpleName() + "MountInfo";
        JavaFileObject jfo = this.processingEnv.getFiler().createSourceFile(context.getApplicationClassTypeElement().getQualifiedName() + "MountInfo", new Element[0]);
        BufferedWriter bw = new BufferedWriter(jfo.openWriter());
        Map<TypeElement, String> mountPoints = context.getMountPoints();
        bw.append("package ");
        bw.append(context.getApplicationPackage().getQualifiedName());
        bw.append(";");
        bw.newLine();
        bw.newLine();
        bw.append("import org.wicketstuff.wicket.mount.core.*;");
        bw.newLine();
        bw.append("import org.apache.wicket.request.IRequestMapper;");
        bw.newLine();
        bw.append("import org.apache.wicket.core.request.mapper.MountedMapper;");
        bw.newLine();
        bw.append("import java.util.*;");
        bw.newLine();
        bw.newLine();
        bw.append("public class " + infoClassName + " implements MountInfo");
        bw.newLine();
        bw.append("{");
        bw.newLine();
        bw.append("\t@Override");
        bw.newLine();
        bw.append("\tpublic List<IRequestMapper> getMountList() {");
        bw.newLine();
        bw.append("\t\tList<IRequestMapper> ret = new ArrayList<IRequestMapper>();");
        bw.newLine();
        for (TypeElement ele : mountPoints.keySet()) {
            bw.append("\t\tret.add(new MountedMapper(\"" + mountPoints.get(ele) + "\", " + ele.getQualifiedName().toString() + ".class));");
            bw.newLine();
        }
        bw.append("\t\treturn ret;");
        bw.newLine();
        bw.append("\t}");
        bw.newLine();
        bw.append("}");
        bw.newLine();
        bw.close();
    }
}

