/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.wicket.mount.core.processor;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;

public class AutoMountContext {
    private final PackageElement applicationPackage;
    private final TypeElement applicationClassTypeElement;
    private final List<String> packagesToScan;
    private final Map<TypeElement, String> mountPoints;

    public AutoMountContext(TypeElement applicationClassTypeElement) {
        this.applicationPackage = (PackageElement)applicationClassTypeElement.getEnclosingElement();
        this.applicationClassTypeElement = applicationClassTypeElement;
        this.packagesToScan = new ArrayList<String>();
        this.mountPoints = new HashMap<TypeElement, String>();
    }

    public <T extends Annotation> T getAppAnnotation(Class<T> annotationClass) {
        return this.applicationClassTypeElement.getAnnotation(annotationClass);
    }

    public PackageElement getApplicationPackage() {
        return this.applicationPackage;
    }

    public TypeElement getApplicationClassTypeElement() {
        return this.applicationClassTypeElement;
    }

    public boolean addPackagesToScan(String ... packages) {
        return Collections.addAll(this.packagesToScan, packages);
    }

    public boolean addPackageToScan(String scanPackage) {
        return this.packagesToScan.add(scanPackage);
    }

    public String[] getPackagesToScan() {
        return this.packagesToScan.toArray(new String[this.packagesToScan.size()]);
    }

    public boolean containsMountPoint(String mountPoint) {
        return this.mountPoints.containsValue(mountPoint);
    }

    public String getMountPoint(TypeElement key) {
        return this.mountPoints.get(key);
    }

    public void setMountPoint(TypeElement key, String path) {
        this.mountPoints.put(key, path);
    }

    public Set<TypeElement> getMountableElements() {
        return this.mountPoints.keySet();
    }

    public Map<TypeElement, String> getMountPoints() {
        return Collections.unmodifiableMap(this.mountPoints);
    }
}

