/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.concurrent;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.clustering.msc.AsynchronousService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossExecutors;

public class RemoveOnCancelScheduledExecutorService
implements Service<ScheduledExecutorService> {
    private final ThreadFactory threadFactory;
    private final int size;
    private volatile ScheduledExecutorService executor;

    public static ServiceBuilder<ScheduledExecutorService> build(ServiceTarget target, ServiceName name, ThreadFactory factory) {
        return RemoveOnCancelScheduledExecutorService.build(target, name, factory, 1);
    }

    public static ServiceBuilder<ScheduledExecutorService> build(ServiceTarget target, ServiceName name, ThreadFactory factory, int size) {
        return AsynchronousService.addService(target, name, new RemoveOnCancelScheduledExecutorService(size, factory), false, true);
    }

    private RemoveOnCancelScheduledExecutorService(int size, ThreadFactory threadFactory) {
        this.size = size;
        this.threadFactory = threadFactory;
    }

    public ScheduledExecutorService getValue() {
        return JBossExecutors.protectedScheduledExecutorService((ScheduledExecutorService)this.executor);
    }

    public void start(StartContext context) {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(this.size, this.threadFactory);
        executor.setRemoveOnCancelPolicy(true);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.executor = executor;
    }

    public void stop(StopContext context) {
        this.executor.shutdown();
        this.executor = null;
    }
}

