/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.descriptions;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.NotificationDefinition;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;

public class DefaultNotificationDescriptionProvider
implements DescriptionProvider {
    private final String notificationType;
    private final ResourceDescriptionResolver descriptionResolver;
    private final NotificationDefinition.DataValueDescriptor dataValueDescriptor;

    public DefaultNotificationDescriptionProvider(String notificationType, ResourceDescriptionResolver descriptionResolver, NotificationDefinition.DataValueDescriptor dataValueDescriptor) {
        this.notificationType = notificationType;
        this.descriptionResolver = descriptionResolver;
        this.dataValueDescriptor = dataValueDescriptor;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        ModelNode dataDescription;
        ModelNode result = new ModelNode();
        ResourceBundle bundle2 = this.descriptionResolver.getResourceBundle(locale);
        result.get("notification-type").set(this.notificationType);
        result.get("description").set(this.descriptionResolver.getNotificationDescription(this.notificationType, locale, bundle2));
        if (this.dataValueDescriptor != null && (dataDescription = this.dataValueDescriptor.describe(bundle2)) != null && dataDescription.isDefined()) {
            result.get("data-type").set(dataDescription);
        }
        return result;
    }
}

