/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.platform.mbean;

import java.lang.management.ManagementFactory;
import java.util.Locale;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.platform.mbean.PlatformMBeanConstants;
import org.jboss.as.platform.mbean.PlatformMBeanDescriptions;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class PlatformLoggingMXBeanGetLoggerLevelHandler
implements OperationStepHandler,
DescriptionProvider {
    public static final PlatformLoggingMXBeanGetLoggerLevelHandler INSTANCE = new PlatformLoggingMXBeanGetLoggerLevelHandler();
    private static final String[] SIGNATURE = new String[]{String.class.getName()};
    private final ParametersValidator parametersValidator = new ParametersValidator();

    private PlatformLoggingMXBeanGetLoggerLevelHandler() {
        this.parametersValidator.registerValidator("logger-name", (ParameterValidator)new ModelTypeValidator(ModelType.STRING, false, false));
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        this.parametersValidator.validate(operation);
        String loggerName = operation.require("logger-name").asString();
        try {
            Object level = ManagementFactory.getPlatformMBeanServer().invoke(PlatformMBeanConstants.PLATFORM_LOGGING_OBJECT_NAME, "getLoggerLevel", new String[]{loggerName}, SIGNATURE);
            ModelNode result = context.getResult();
            if (level != null) {
                result.set(level.toString());
            }
        }
        catch (JMRuntimeException e) {
            throw e;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
        context.stepCompleted();
    }

    public ModelNode getModelDescription(Locale locale) {
        return PlatformMBeanDescriptions.getGetLoggerLevelDescription(locale);
    }
}

