/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.util.Collections;
import java.util.Set;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.BaseJsonValidator;
import wiremock.com.networknt.schema.ExecutionContext;
import wiremock.com.networknt.schema.JsonNodePath;
import wiremock.com.networknt.schema.JsonSchema;
import wiremock.com.networknt.schema.JsonValidator;
import wiremock.com.networknt.schema.MessageSourceValidationMessage;
import wiremock.com.networknt.schema.SchemaLocation;
import wiremock.com.networknt.schema.ValidationContext;
import wiremock.com.networknt.schema.ValidationMessage;
import wiremock.com.networknt.schema.ValidatorTypeCode;
import wiremock.org.slf4j.Logger;
import wiremock.org.slf4j.LoggerFactory;

public class MaxPropertiesValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(MaxPropertiesValidator.class);
    private final int max;

    public MaxPropertiesValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.MAX_PROPERTIES, validationContext);
        this.max = schemaNode.canConvertToExactIntegral() ? schemaNode.intValue() : Integer.MAX_VALUE;
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node, JsonNode rootNode, JsonNodePath instanceLocation) {
        MaxPropertiesValidator.debug(logger, executionContext, node, rootNode, instanceLocation);
        if (node.isObject() && node.size() > this.max) {
            return Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(this.max)).build());
        }
        return Collections.emptySet();
    }
}

