/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import wiremock.com.fasterxml.jackson.databind.JsonNode;
import wiremock.com.networknt.schema.JsonSchemaException;
import wiremock.com.networknt.schema.JsonSchemaFactory;
import wiremock.com.networknt.schema.SpecVersion;

public final class SpecVersionDetector {
    private static final Map<String, SpecVersion.VersionFlag> supportedVersions = new HashMap<String, SpecVersion.VersionFlag>();
    private static final String SCHEMA_TAG = "$schema";

    private SpecVersionDetector() {
    }

    public static SpecVersion.VersionFlag detect(JsonNode jsonNode) {
        return SpecVersionDetector.detectOptionalVersion(jsonNode, true).orElseThrow(() -> new JsonSchemaException("'$schema' tag is not present"));
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(JsonNode jsonNode, boolean throwIfUnsupported) {
        return Optional.ofNullable(jsonNode.get(SCHEMA_TAG)).map(schemaTag -> {
            String schemaTagValue = schemaTag.asText();
            String schemaUri = JsonSchemaFactory.normalizeMetaSchemaUri(schemaTagValue);
            if (throwIfUnsupported) {
                return SpecVersion.VersionFlag.fromId(schemaUri).orElseThrow(() -> new JsonSchemaException("'" + schemaTagValue + "' is unrecognizable schema"));
            }
            return SpecVersion.VersionFlag.fromId(schemaUri).orElse(null);
        });
    }

    public static SpecVersion.VersionFlag detectVersion(JsonNode jsonNode, Path specification, SpecVersion.VersionFlag defaultVersion, boolean throwIfUnsupported) {
        return Stream.of(SpecVersionDetector.detectOptionalVersion(jsonNode, throwIfUnsupported), SpecVersionDetector.detectVersionFromPath(specification)).filter(Optional::isPresent).map(Optional::get).findFirst().orElse(defaultVersion);
    }

    public static Optional<SpecVersion.VersionFlag> detectVersionFromPath(Path path) {
        return StreamSupport.stream(path.spliterator(), false).map(Path::toString).map(supportedVersions::get).filter(Objects::nonNull).findAny();
    }

    public static Optional<SpecVersion.VersionFlag> detectOptionalVersion(String schemaUri) {
        return SpecVersion.VersionFlag.fromId(schemaUri);
    }

    static {
        supportedVersions.put("draft2019-09", SpecVersion.VersionFlag.V201909);
        supportedVersions.put("draft2020-12", SpecVersion.VersionFlag.V202012);
        supportedVersions.put("draft4", SpecVersion.VersionFlag.V4);
        supportedVersions.put("draft6", SpecVersion.VersionFlag.V6);
        supportedVersions.put("draft7", SpecVersion.VersionFlag.V7);
    }
}

