/*
 * Decompiled with CFR 0.152.
 */
package wiremock.com.networknt.schema.resource;

import java.io.FileNotFoundException;
import java.io.InputStream;
import wiremock.com.networknt.schema.AbsoluteIri;
import wiremock.com.networknt.schema.resource.InputStreamSource;
import wiremock.com.networknt.schema.resource.SchemaLoader;

public class ClasspathSchemaLoader
implements SchemaLoader {
    @Override
    public InputStreamSource getSchema(AbsoluteIri absoluteIri) {
        String iri = absoluteIri != null ? absoluteIri.toString() : "";
        String name = null;
        if (iri.startsWith("classpath:")) {
            name = iri.substring(10);
        } else if (iri.startsWith("resource:")) {
            name = iri.substring(9);
        }
        if (name != null) {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = SchemaLoader.class.getClassLoader();
            }
            ClassLoader loader = classLoader;
            if (name.startsWith("//")) {
                name = name.substring(2);
            }
            String resource = name;
            return () -> {
                InputStream result = loader.getResourceAsStream(resource);
                if (result == null) {
                    result = loader.getResourceAsStream(resource.substring(1));
                }
                if (result == null) {
                    throw new FileNotFoundException(iri);
                }
                return result;
            };
        }
        return null;
    }
}

