/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.stubbing;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import com.github.tomakehurst.wiremock.stubbing.StubMapping;
import java.util.ArrayList;
import java.util.List;

public class StubImportBuilder {
    private List<StubMapping> mappings = new ArrayList<StubMapping>();
    private StubImport.Options.DuplicatePolicy duplicatePolicy = StubImport.Options.DuplicatePolicy.OVERWRITE;
    private Boolean deleteAllNotInImport = false;

    StubImportBuilder() {
    }

    public StubImportBuilder stub(MappingBuilder stubMappingBuilder) {
        this.mappings.add(stubMappingBuilder.build());
        return this;
    }

    public StubImportBuilder stub(StubMapping stubMapping) {
        this.mappings.add(stubMapping);
        return this;
    }

    public StubImportBuilder ignoreExisting() {
        this.duplicatePolicy = StubImport.Options.DuplicatePolicy.IGNORE;
        return this;
    }

    public StubImportBuilder overwriteExisting() {
        this.duplicatePolicy = StubImport.Options.DuplicatePolicy.OVERWRITE;
        return this;
    }

    public StubImportBuilder deleteAllExistingStubsNotInImport() {
        this.deleteAllNotInImport = true;
        return this;
    }

    public StubImportBuilder doNotDeleteExistingStubs() {
        this.deleteAllNotInImport = false;
        return this;
    }

    public StubImport build() {
        return new StubImport(this.mappings, new StubImport.Options(this.duplicatePolicy, this.deleteAllNotInImport));
    }
}

