/*
 * Decompiled with CFR 0.152.
 */
package wiremock.org.xmlunit.diff;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;
import wiremock.org.xmlunit.diff.ElementSelector;
import wiremock.org.xmlunit.diff.ElementSelectors;
import wiremock.org.xmlunit.util.Predicate;

class DefaultConditionalSelectorBuilder
implements ElementSelectors.ConditionalSelectorBuilder,
ElementSelectors.ConditionalSelectorBuilderThen {
    private ElementSelector defaultSelector;
    private final Map<Predicate<? super Element>, ElementSelector> conditionalSelectors = new LinkedHashMap<Predicate<? super Element>, ElementSelector>();
    private Predicate<? super Element> pendingCondition;

    DefaultConditionalSelectorBuilder() {
    }

    @Override
    public ElementSelectors.ConditionalSelectorBuilder thenUse(ElementSelector es) {
        if (this.pendingCondition == null) {
            throw new IllegalStateException("missing condition");
        }
        this.conditionalSelectors.put(this.pendingCondition, es);
        this.pendingCondition = null;
        return this;
    }

    @Override
    public ElementSelectors.ConditionalSelectorBuilderThen when(Predicate<? super Element> predicate) {
        if (this.pendingCondition != null) {
            throw new IllegalStateException("unbalanced conditions");
        }
        this.pendingCondition = predicate;
        return this;
    }

    @Override
    public ElementSelectors.ConditionalSelectorBuilder elseUse(ElementSelector es) {
        if (this.defaultSelector != null) {
            throw new IllegalStateException("can't have more than one default selector");
        }
        this.defaultSelector = es;
        return this;
    }

    @Override
    public ElementSelectors.ConditionalSelectorBuilderThen whenElementIsNamed(String expectedName) {
        return this.when(ElementSelectors.elementNamePredicate(expectedName));
    }

    @Override
    public ElementSelectors.ConditionalSelectorBuilderThen whenElementIsNamed(QName expectedName) {
        return this.when(ElementSelectors.elementNamePredicate(expectedName));
    }

    @Override
    public ElementSelector build() {
        if (this.pendingCondition != null) {
            throw new IllegalStateException("unbalanced conditions");
        }
        return new ConditionalSelector(this.conditionalSelectors, this.defaultSelector);
    }

    private static class ConditionalSelector
    implements ElementSelector {
        private final Map<Predicate<? super Element>, ElementSelector> conditionalSelectors;
        private final ElementSelector defaultSelector;

        private ConditionalSelector(Map<Predicate<? super Element>, ElementSelector> conditionalSelectors, ElementSelector defaultSelector) {
            this.conditionalSelectors = new LinkedHashMap<Predicate<? super Element>, ElementSelector>(conditionalSelectors);
            this.defaultSelector = defaultSelector;
        }

        @Override
        public boolean canBeCompared(Element controlElement, Element testElement) {
            for (Map.Entry<Predicate<? super Element>, ElementSelector> e : this.conditionalSelectors.entrySet()) {
                if (!e.getKey().test(controlElement)) continue;
                return e.getValue().canBeCompared(controlElement, testElement);
            }
            if (this.defaultSelector != null) {
                return this.defaultSelector.canBeCompared(controlElement, testElement);
            }
            return false;
        }
    }
}

