/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.byoc.ci;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.ControlTask;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.cloud.ci.BaseHostTemplate;
import com.xebialabs.deployit.plugin.cloud.ci.CloudEnvironmentParameters;
import com.xebialabs.deployit.plugin.cloud.step.CheckParametersStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterEnvironmentStep;
import com.xebialabs.deployit.plugin.cloud.step.RegisterInstancesStep;
import com.xebialabs.deployit.plugin.cloud.step.plan.SingleStepFilter;
import com.xebialabs.deployit.plugin.cloud.step.plan.StepOrderComparator;
import com.xebialabs.deployit.plugin.cloud.util.CiParser;
import com.xebialabs.deployit.plugin.cloud.util.InstanceDescriptorResolver;
import com.xebialabs.deployit.plugin.cloud.util.MapsHelper;
import com.xebialabs.deployit.plugins.byoc.ci.HostTemplate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Metadata(description="BYOC environment template", root=Metadata.ConfigurationItemRoot.CONFIGURATION)
public class EnvironmentTemplate
extends com.xebialabs.deployit.plugin.cloud.ci.EnvironmentTemplate {
    protected static Type BYOC_HOST_TEMPLATE_TYPE = Type.valueOf(HostTemplate.class);
    private static InstanceDescriptorResolver descriptorResolver = new InstanceDescriptorResolver();
    private static CiParser ciParser = new CiParser();

    @ControlTask(label="Instantiate environment", parameterType="cloud.CloudEnvironmentParameters", description="Instantiate environment and all hosts, which templates are linked to this environment template")
    public List<? extends Step> instantiate(CloudEnvironmentParameters parameters) {
        ArrayList steps = Lists.newArrayList();
        steps.add(new CheckParametersStep(parameters));
        HashMap waitStepsAdded = Maps.newHashMap();
        if (!this.getHostTemplates().isEmpty()) {
            int seq = 1;
            for (BaseHostTemplate template : this.getHostTemplates()) {
                List<? extends Step> createSteps = template.getType().instanceOf(BYOC_HOST_TEMPLATE_TYPE) ? ((HostTemplate)template).produceCreateSteps(this.getName(), seq, parameters) : template.produceCreateSteps(this.getName(), seq);
                Collection stepsToAdd = Collections2.filter(createSteps, (Predicate)new SingleStepFilter((Map)waitStepsAdded, template.getType()));
                steps.addAll(stepsToAdd);
                MapsHelper.putOrMerge((Map)waitStepsAdded, (Object)template.getType(), (Collection)Lists.newArrayList((Iterable)stepsToAdd));
                ++seq;
            }
            steps.add(new RegisterInstancesStep(descriptorResolver, ciParser, parameters.getHostsPath()));
        }
        steps.add(new RegisterEnvironmentStep(descriptorResolver, ciParser, (com.xebialabs.deployit.plugin.cloud.ci.EnvironmentTemplate)this, parameters.getEnvironmentId()));
        Collections.sort(steps, new StepOrderComparator());
        return steps;
    }
}

