/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.byoc.steps;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugins.byoc.ci.HostTemplate;
import com.xebialabs.deployit.plugins.byoc.util.CommandRunner;
import com.xebialabs.deployit.plugins.byoc.util.StderrProcessOutputHandler;
import com.xebialabs.deployit.plugins.byoc.util.StdoutProcessOutputHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;

public class CreateAndProvisionHostStep
implements Step {
    private final HostTemplate template;
    private final String instanceName;
    private final Map<String, Object> freemarkerContext;

    public CreateAndProvisionHostStep(HostTemplate hostTemplate, String instanceLabel, int instanceSeq, Parameters params) {
        this.template = hostTemplate;
        this.instanceName = instanceLabel;
        this.freemarkerContext = ImmutableMap.of((Object)"hostTemplate", (Object)((Object)this.template), (Object)"sequenceNumber", (Object)instanceSeq, (Object)"params", (Object)params);
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Create and provision " + this.instanceName;
    }

    public StepExitCode execute(ExecutionContext context) throws Exception {
        try {
            CommandRunner runner = new CommandRunner(this.template.getWorkingDirectory(), this.buildCommand(), new StdoutProcessOutputHandler(context), new StderrProcessOutputHandler(context));
            int result = runner.run(context);
            if (result == 0) {
                ContextHelper.wrapped((ExecutionContext)context).safeSet((Enum)ContextAttribute.USED_TEMPLATES, new ArrayList(), Arrays.asList(this.template));
                return StepExitCode.SUCCESS;
            }
            context.logError("Creation and provisioning command returned exit code " + result);
            return StepExitCode.FAIL;
        }
        catch (Throwable t) {
            context.logError("Error running creation and provisioning command: " + t);
            return StepExitCode.FAIL;
        }
    }

    private String[] buildCommand() {
        String createCommand = ConfigurationHolder.resolveExpression((String)this.template.getCreateCommand(), this.freemarkerContext);
        return createCommand.split(" ");
    }
}

