/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.byoc.steps;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugins.byoc.ci.HostTemplate;
import com.xebialabs.deployit.plugins.byoc.util.ByocCloudId;
import com.xebialabs.deployit.plugins.byoc.util.CommandRunner;
import com.xebialabs.deployit.plugins.byoc.util.StderrProcessOutputHandler;
import com.xebialabs.deployit.plugins.byoc.util.StdoutProcessOutputHandler;
import java.util.Map;

public class DestroyHostStep
implements Step {
    private static final String CLOUD_ID_PROPERTY = "cloudId";
    private final HostTemplate template;
    private final String instanceName;
    private final Map<String, Object> freemarkerContext;

    public DestroyHostStep(HostTemplate hostTemplate, ConfigurationItem instance) {
        this.template = hostTemplate;
        this.instanceName = instance.getName();
        Preconditions.checkState((boolean)instance.hasProperty(CLOUD_ID_PROPERTY), (String)"'%s' is not a cloud-generated CI: missing property 'cloudId'", (Object[])new Object[]{instance.getId()});
        ByocCloudId cloudId = ByocCloudId.fromCloudId((String)instance.getProperty(CLOUD_ID_PROPERTY));
        this.freemarkerContext = ImmutableMap.of((Object)"hostTemplate", (Object)((Object)this.template), (Object)"sequenceNumber", (Object)cloudId.getSequenceNumber(), (Object)"host", (Object)instance);
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Destroy instance " + this.instanceName;
    }

    public StepExitCode execute(ExecutionContext context) throws Exception {
        try {
            CommandRunner runner = new CommandRunner(this.template.getWorkingDirectory(), this.buildCommand(), new StdoutProcessOutputHandler(context), new StderrProcessOutputHandler(context));
            int result = runner.run(context);
            if (result == 0) {
                return StepExitCode.SUCCESS;
            }
            context.logError("Deprovisioning command returned exit code " + result);
            return StepExitCode.FAIL;
        }
        catch (Throwable t) {
            context.logError("Error running deprovisioning command: " + t);
            return StepExitCode.FAIL;
        }
    }

    private String[] buildCommand() {
        String destroyCommand = ConfigurationHolder.resolveExpression((String)this.template.getDestroyCommand(), this.freemarkerContext);
        return destroyCommand.split(" ");
    }
}

