/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.byoc.steps;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.api.udm.Parameters;
import com.xebialabs.deployit.plugin.cloud.step.ContextAttribute;
import com.xebialabs.deployit.plugin.cloud.util.ContextHelper;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import com.xebialabs.deployit.plugins.byoc.ci.HostTemplate;
import com.xebialabs.deployit.plugins.byoc.util.ByocCloudId;
import com.xebialabs.deployit.plugins.byoc.util.CapturingStdoutProcessOutputHandler;
import com.xebialabs.deployit.plugins.byoc.util.CommandRunner;
import com.xebialabs.deployit.plugins.byoc.util.StderrProcessOutputHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FindIpAddressStep
implements Step {
    private final HostTemplate template;
    private final String instanceName;
    private final int sequenceNumber;
    private final Map<String, Object> freemarkerContext;

    public FindIpAddressStep(HostTemplate hostTemplate, String instanceLabel, int instanceSeq, Parameters params) {
        this.template = hostTemplate;
        this.instanceName = instanceLabel;
        this.sequenceNumber = instanceSeq;
        this.freemarkerContext = ImmutableMap.of((Object)"hostTemplate", (Object)((Object)this.template), (Object)"sequenceNumber", (Object)instanceSeq, (Object)"params", (Object)params);
    }

    public int getOrder() {
        return 50;
    }

    public String getDescription() {
        return "Determine IP address for instance " + this.instanceName;
    }

    public StepExitCode execute(ExecutionContext context) throws Exception {
        try {
            CapturingStdoutProcessOutputHandler outputGobbler = new CapturingStdoutProcessOutputHandler(context);
            CommandRunner runner = new CommandRunner(this.template.getWorkingDirectory(), this.buildCommand(), outputGobbler, new StderrProcessOutputHandler(context));
            int result = runner.run(context);
            Thread.sleep(1000L);
            if (result == 0) {
                String ipAddress = this.findIpAddress(outputGobbler.getOutput());
                context.logOutput("Found IP address " + ipAddress);
                ByocCloudId cloudId = new ByocCloudId(ipAddress, this.sequenceNumber);
                ContextHelper.wrapped((ExecutionContext)context).safeSet((Enum)ContextAttribute.CREATED_INSTANCES, new ArrayList(), Arrays.asList(cloudId.toString()));
                return StepExitCode.SUCCESS;
            }
            context.logError("IP address discovery command returned exit code " + result);
            return StepExitCode.FAIL;
        }
        catch (Throwable t) {
            context.logError("Error running IP address discovery command: " + t);
            return StepExitCode.FAIL;
        }
    }

    private String[] buildCommand() {
        String findIpAddressCommand = ConfigurationHolder.resolveExpression((String)this.template.getFindIpAddressCommand(), this.freemarkerContext);
        return findIpAddressCommand.split(" ");
    }

    protected String findIpAddress(String output) {
        Pattern p = Pattern.compile(this.template.getFindIpAddressRegex(), 8);
        Matcher matcher = p.matcher(output);
        if (matcher.find()) {
            return matcher.group(1);
        }
        throw new IllegalStateException(String.format("Unable to determine IP address from output '%s' using pattern '%s'", output, p.pattern()));
    }
}

