/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugins.byoc.util;

import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugins.byoc.util.ProcessOutputHandler;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandRunner {
    public static final Logger LOGGER = LoggerFactory.getLogger(CommandRunner.class);
    private final String[] command;
    private final ProcessOutputHandler stdout;
    private final ProcessOutputHandler stderr;
    private final String workingDir;

    public CommandRunner(String workingDir, String[] command, ProcessOutputHandler stdout, ProcessOutputHandler stderr) {
        this.workingDir = workingDir;
        this.command = command;
        this.stdout = stdout;
        this.stderr = stderr;
    }

    public int run(ExecutionContext context) throws Exception {
        LOGGER.debug("Invoking command '%s' in directory '%s'", (Object)this.command, (Object)this.workingDir);
        context.logOutput("Invoking command in directory " + this.workingDir);
        try {
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(this.command, null, new File(this.workingDir));
            this.stdout.startWithStream(p.getInputStream());
            this.stderr.startWithStream(p.getErrorStream());
            return p.waitFor();
        }
        catch (Throwable t) {
            context.logError("Error running command: " + t);
            return -1;
        }
    }
}

