/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lb.planning;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.xebialabs.deployit.plugin.api.deployment.specification.Delta;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Deployed;
import ext.deployit.community.plugin.lb.util.Predicates2;
import java.util.Set;

public abstract class ContainerContributor<T> {
    protected final Predicate<Object> isTargetContainerClass;
    protected Set<T> containers;

    protected ContainerContributor(Class<T> containerClass) {
        this.isTargetContainerClass = Predicates.instanceOf(containerClass);
    }

    protected void collectContainers(Deltas deltas) {
        Iterable nonNoopDeltas = Iterables.filter((Iterable)deltas.getDeltas(), (Predicate)Predicates.not(Predicates2.operationIs(Operation.NOOP)));
        this.containers = ImmutableSet.copyOf((Iterable)Iterables.filter((Iterable)Iterables.transform((Iterable)nonNoopDeltas, (Function)new Function<Delta, Container>(){

            public Container apply(Delta input) {
                return this.getDeployed(input).getContainer();
            }

            private Deployed<?, ?> getDeployed(Delta delta) {
                return delta.getOperation().equals((Object)Operation.DESTROY) ? delta.getPrevious() : delta.getDeployed();
            }
        }), this.isTargetContainerClass));
    }
}

