/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lb.planning;

import com.google.common.collect.ImmutableMap;
import com.xebialabs.deployit.plugin.api.deployment.planning.Contributor;
import com.xebialabs.deployit.plugin.api.deployment.planning.DeploymentPlanningContext;
import com.xebialabs.deployit.plugin.api.deployment.specification.Deltas;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.reflect.Type;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import com.xebialabs.deployit.plugin.generic.step.ScriptExecutionStep;
import com.xebialabs.deployit.plugin.overthere.HostContainer;
import ext.deployit.community.plugin.lb.planning.ContainerContributor;
import ext.deployit.community.plugin.lb.util.DeploymentGroups;
import ext.deployit.community.plugin.lb.util.Environments;
import ext.deployit.community.plugin.lb.util.LoadBalancedContainers;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageLoadBalancerPools
extends ContainerContributor<Container> {
    private static final Type LOADBALANCER_TYPE = Type.valueOf((String)"lb.GenericLoadBalancer");
    private static final String LOADBALANCER_REMOVE_FROM_POOL_SCRIPT_PROPERTY = "removeFromLoadBalancerPoolScript";
    private static final String LOADBALANCER_REMOVE_FROM_POOL_ORDER_PROPERTY = "removeFromLoadBalancerPoolOrder";
    private static final String LOADBALANCER_RETURN_TO_POOL_SCRIPT_PROPERTY = "returnToLoadBalancerPoolScript";
    private static final String LOADBALANCER_RETURN_TO_POOL_ORDER_PROPERTY = "returnToLoadBalancerPoolOrder";
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageLoadBalancerPools.class);

    public ManageLoadBalancerPools() {
        super(Container.class);
    }

    @Contributor
    public void manageContainersInPool(Deltas deltas, DeploymentPlanningContext ctx) {
        this.collectContainers(deltas);
        Environment targetEnvironment = ctx.getDeployedApplication().getEnvironment();
        Set<GenericContainer> loadBalancers = Environments.getMembersOfType(targetEnvironment, LOADBALANCER_TYPE);
        if (loadBalancers.isEmpty()) {
            LOGGER.debug("No load balancers in environment. Nothing to do.");
            return;
        }
        Map<Container, List<GenericContainer>> containerLoadBalancers = LoadBalancedContainers.getContainerLoadBalancers(loadBalancers);
        Map<Container, LoadBalancedContainers.LoadBalancingBounds> containerBalancingBounds = LoadBalancedContainers.getLoadBalancingBounds(containerLoadBalancers.keySet());
        Integer currentDeploymentGroup = this.getCurrentDeploymentGroup(this.containers);
        if (currentDeploymentGroup == null) {
            String.format("Unable to determine deployment group for containers: %s. Will not add steps.", this.containers);
            return;
        }
        for (Map.Entry<Container, LoadBalancedContainers.LoadBalancingBounds> balancingBounds : containerBalancingBounds.entrySet()) {
            Container container = balancingBounds.getKey();
            LoadBalancedContainers.LoadBalancingBounds bounds = balancingBounds.getValue();
            if (bounds.startGroup == currentDeploymentGroup) {
                LOGGER.debug("Adding 'remove from pool' steps for container with start group '{}' (current group: '{}'", (Object)bounds.startGroup, (Object)currentDeploymentGroup);
                ManageLoadBalancerPools.addRemoveFromPoolSteps(ctx, container, containerLoadBalancers.get(container));
            }
            if (bounds.endGroup != currentDeploymentGroup) continue;
            LOGGER.debug("Adding 'return to pool' steps for container with end group '{}' (current group: '{}'", (Object)bounds.endGroup, (Object)currentDeploymentGroup);
            ManageLoadBalancerPools.addReturnToPoolSteps(ctx, container, containerLoadBalancers.get(container));
        }
    }

    private Integer getCurrentDeploymentGroup(Set<Container> containers) {
        Iterator<Container> i$ = containers.iterator();
        if (i$.hasNext()) {
            Container container = i$.next();
            return DeploymentGroups.getDeploymentGroup(container);
        }
        return null;
    }

    private static void addRemoveFromPoolSteps(DeploymentPlanningContext ctx, Container container, List<GenericContainer> loadBalancers) {
        for (GenericContainer loadBalancer : loadBalancers) {
            ctx.addStep((Step)new ScriptExecutionStep(((Integer)loadBalancer.getProperty(LOADBALANCER_REMOVE_FROM_POOL_ORDER_PROPERTY)).intValue(), (String)loadBalancer.getProperty(LOADBALANCER_REMOVE_FROM_POOL_SCRIPT_PROPERTY), (HostContainer)loadBalancer, ManageLoadBalancerPools.getFreeMarkerContext(container, (Container)loadBalancer), String.format("Remove %s from load balancer pool of %s", container, loadBalancer)));
        }
    }

    private static void addReturnToPoolSteps(DeploymentPlanningContext ctx, Container container, List<GenericContainer> loadBalancers) {
        for (GenericContainer loadBalancer : loadBalancers) {
            ctx.addStep((Step)new ScriptExecutionStep(((Integer)loadBalancer.getProperty(LOADBALANCER_RETURN_TO_POOL_ORDER_PROPERTY)).intValue(), (String)loadBalancer.getProperty(LOADBALANCER_RETURN_TO_POOL_SCRIPT_PROPERTY), (HostContainer)loadBalancer, ManageLoadBalancerPools.getFreeMarkerContext(container, (Container)loadBalancer), String.format("Return %s to load balancer pool of %s", container, loadBalancer)));
        }
    }

    private static Map<String, Object> getFreeMarkerContext(Container container, Container loadBalancer) {
        return ImmutableMap.of((Object)"container", (Object)loadBalancer, (Object)"poolmember", (Object)container);
    }
}

