/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lb.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.udm.Container;
import com.xebialabs.deployit.plugin.generic.ci.GenericContainer;
import ext.deployit.community.plugin.lb.util.DeploymentGroups;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBalancedContainers {
    private static final String WEBSERVER_FRONTED_CONTAINERS_PROPERTY = "frontedServers";
    private static final String CONTAINER_REMOVE_FROM_POOL_PROPERTY = "removeFromLoadBalancerPool";
    private static final String LOADBALANCER_WEBSERVER_POOL_PROPERTY = "webserverPool";
    private static final String LOADBALANCER_APPSERVER_POOL_PROPERTY = "appserverPool";

    public static Map<Container, List<GenericContainer>> getContainerLoadBalancers(Set<GenericContainer> loadBalancers) {
        HashMap loadBalancedContainers = Maps.newHashMap();
        for (GenericContainer loadBalancer : loadBalancers) {
            for (Container webserver : (Set)loadBalancer.getProperty(LOADBALANCER_WEBSERVER_POOL_PROPERTY)) {
                if (!Boolean.TRUE.equals(webserver.getProperty(CONTAINER_REMOVE_FROM_POOL_PROPERTY))) continue;
                LoadBalancedContainers.addContainer(loadBalancedContainers, webserver, loadBalancer);
            }
            for (Container appserver : (Set)loadBalancer.getProperty(LOADBALANCER_APPSERVER_POOL_PROPERTY)) {
                if (!Boolean.TRUE.equals(appserver.getProperty(CONTAINER_REMOVE_FROM_POOL_PROPERTY))) continue;
                LoadBalancedContainers.addContainer(loadBalancedContainers, appserver, loadBalancer);
            }
        }
        return loadBalancedContainers;
    }

    private static void addContainer(Map<Container, List<GenericContainer>> loadBalancedContainers, Container container, GenericContainer loadBalancer) {
        if (!loadBalancedContainers.containsKey(container)) {
            loadBalancedContainers.put(container, Lists.newArrayList());
        }
        loadBalancedContainers.get(container).add(loadBalancer);
    }

    public static Map<Container, LoadBalancingBounds> getLoadBalancingBounds(Set<Container> containers) {
        ImmutableMap.Builder loadBalancingBounds = ImmutableMap.builder();
        for (Container container : containers) {
            loadBalancingBounds.put((Object)container, (Object)new LoadBalancingBounds(container));
        }
        return loadBalancingBounds.build();
    }

    public static class LoadBalancingBounds {
        private static final Logger LOGGER = LoggerFactory.getLogger(LoadBalancingBounds.class);
        public final int startGroup;
        public final int endGroup;

        private LoadBalancingBounds(Container container) {
            if (container.hasProperty(LoadBalancedContainers.WEBSERVER_FRONTED_CONTAINERS_PROPERTY)) {
                ArrayList deploymentGroups = Lists.newArrayList();
                Set frontedServers = (Set)container.getProperty(LoadBalancedContainers.WEBSERVER_FRONTED_CONTAINERS_PROPERTY);
                for (Container frontedServer : frontedServers) {
                    deploymentGroups.add(DeploymentGroups.getDeploymentGroup(frontedServer));
                }
                Collections.sort(deploymentGroups);
                this.startGroup = (Integer)deploymentGroups.get(0);
                this.endGroup = (Integer)deploymentGroups.get(deploymentGroups.size() - 1);
            } else {
                this.endGroup = this.startGroup = DeploymentGroups.getDeploymentGroup(container);
            }
            LOGGER.debug("Determined load balancing bounds for '{}': start '{}', end '{}'", new Object[]{container, this.startGroup, this.endGroup});
        }
    }
}

