/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.lock;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.udm.ConfigurationItem;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class LockHelper
implements Serializable {
    private final String LOCK_FILE_DIRECTORY = "locks";

    public boolean atomicallyLock(Collection<ConfigurationItem> cis) {
        HashSet<ConfigurationItem> acquiredLocks = new HashSet<ConfigurationItem>();
        for (ConfigurationItem ci : cis) {
            try {
                if (!this.lock(ci)) continue;
                acquiredLocks.add(ci);
            }
            catch (Exception e) {}
        }
        if (acquiredLocks.size() != cis.size()) {
            for (ConfigurationItem lockedCi : acquiredLocks) {
                this.unlock(lockedCi);
            }
        }
        return acquiredLocks.size() == cis.size();
    }

    public void unlock(Set<ConfigurationItem> cisToBeUnlocked) {
        for (ConfigurationItem ci : cisToBeUnlocked) {
            this.unlock(ci);
        }
    }

    public boolean lock(ConfigurationItem ci) throws IOException {
        this.createLockDirectoryIfNotExists();
        File lockFile = this.getLockFile(ci);
        if (lockFile.createNewFile()) {
            PrintWriter pw = new PrintWriter(lockFile);
            pw.println("Locking " + ci.getName() + " on " + new Date());
            pw.close();
            return true;
        }
        return false;
    }

    public void unlock(ConfigurationItem ci) {
        this.createLockDirectoryIfNotExists();
        if (!this.getLockFile(ci).delete()) {
            throw new RuntimeException("Failed to unlock " + ci.getName());
        }
    }

    public boolean isLocked(ConfigurationItem ci) {
        return this.getLockFile(ci).exists();
    }

    public void clearLocks() {
        this.createLockDirectoryIfNotExists();
        for (String lockFile : this.getLockFileList()) {
            if (new File("locks", lockFile).delete()) continue;
            throw new RuntimeException("Unable to delete lock file " + lockFile);
        }
    }

    public List<String> listLocks() {
        this.createLockDirectoryIfNotExists();
        return Lists.newArrayList((Iterable)Iterables.transform(this.getLockFileList(), (Function)new Function<String, String>(){

            public String apply(String input) {
                return LockHelper.this.lockFileNameToCiId(input);
            }
        }));
    }

    private List<String> getLockFileList() {
        return Lists.newArrayList((Object[])new File("locks").list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".lock");
            }
        }));
    }

    private File getLockFile(ConfigurationItem ci) {
        return new File("locks", this.ciIdToLockFileName(ci.getId()));
    }

    String ciIdToLockFileName(String ciId) {
        return ciId.replaceAll("/", "\\$") + ".lock";
    }

    String lockFileNameToCiId(String lockFileName) {
        return lockFileName.replaceAll("\\$", "/").replace(".lock", "");
    }

    private File createLockDirectoryIfNotExists() {
        return this.createLockDirectoryIfNotExists("locks");
    }

    private File createLockDirectoryIfNotExists(String directory) {
        File lockDir = new File(directory);
        if (lockDir.exists() && lockDir.isDirectory()) {
            return lockDir;
        }
        lockDir.mkdir();
        if (!lockDir.exists() || !lockDir.isDirectory()) {
            throw new RuntimeException("Unable to create lock directory");
        }
        return lockDir;
    }
}

