/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.manualstep.ci;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.xebialabs.deployit.plugin.api.deployment.specification.Operation;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import com.xebialabs.deployit.plugin.api.udm.Metadata;
import com.xebialabs.deployit.plugin.api.udm.Property;
import com.xebialabs.deployit.plugin.api.udm.base.BaseConfigurationItem;
import ext.deployit.community.plugin.manualstep.ci.ContributorType;
import ext.deployit.community.plugin.manualstep.ci.DeploymentOperation;
import ext.deployit.community.plugin.manualstep.ci.ManualStep;
import java.util.Collections;
import java.util.List;

@Metadata(root=Metadata.ConfigurationItemRoot.CONFIGURATION, description="Contains a list of ManualStep configurations.")
public class ManualSteps
extends BaseConfigurationItem {
    public static final String MANUAL_STEPS = "manualSteps";
    @Property(description="List of ManualStep configurations")
    private List<ManualStep> steps = Lists.newArrayList();

    public List<ManualStep> getSteps() {
        return this.steps;
    }

    public void setSteps(List<ManualStep> steps) {
        this.steps = steps;
    }

    public static Iterable<ManualStep> getSteps(Environment environment, final ContributorType contributorType, final Operation operation) {
        if (!environment.hasProperty(MANUAL_STEPS)) {
            return Collections.emptyList();
        }
        List manualStepSets = (List)environment.getProperty(MANUAL_STEPS);
        Iterable manualSteps = Iterables.concat((Iterable)Lists.transform((List)manualStepSets, (Function)new Function<ManualSteps, Iterable<ManualStep>>(){

            public Iterable<ManualStep> apply(ManualSteps input) {
                return Iterables.filter(input.getSteps(), (Predicate)new Predicate<ManualStep>(){

                    public boolean apply(ManualStep input) {
                        return input.getContributorType() == contributorType && (input.getOperation() == DeploymentOperation.ANY || input.getOperation().getOperation() == operation);
                    }
                });
            }
        }));
        return manualSteps;
    }
}

