/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.manualstep.contrib;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.xebialabs.deployit.plugin.api.deployment.planning.PostPlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.planning.PrePlanProcessor;
import com.xebialabs.deployit.plugin.api.deployment.specification.DeltaSpecification;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.udm.Environment;
import ext.deployit.community.plugin.manualstep.ci.ContributorType;
import ext.deployit.community.plugin.manualstep.ci.ManualStep;
import ext.deployit.community.plugin.manualstep.ci.ManualSteps;
import ext.deployit.community.plugin.manualstep.step.InstructionStep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ManualStepProcessor {
    @PrePlanProcessor
    public List<Step> triggerManualStepsForPrePlanProcessor(DeltaSpecification deltaSpec) {
        return this.triggerManualSteps(deltaSpec, ContributorType.ONCE_AT_THE_START);
    }

    @PostPlanProcessor
    public List<Step> triggerManualStepsForPostPlanProcessor(DeltaSpecification deltaSpec) {
        return this.triggerManualSteps(deltaSpec, ContributorType.ONCE_AT_THE_END);
    }

    private List<Step> triggerManualSteps(DeltaSpecification deltaSpec, ContributorType contributorType) {
        HashMap commonVars = Maps.newHashMap();
        commonVars.put("deltas", deltaSpec.getDeltas());
        commonVars.put("deployedApplication", deltaSpec.getDeployedApplication());
        commonVars.put("previousDeployedApplication", deltaSpec.getPreviousDeployedApplication());
        commonVars.put("operation", deltaSpec.getOperation());
        Environment environment = deltaSpec.getDeployedApplication().getEnvironment();
        Iterable<ManualStep> manualSteps = ManualSteps.getSteps(environment, contributorType, deltaSpec.getOperation());
        ArrayList steps = Lists.newArrayList();
        for (ManualStep manualStep : manualSteps) {
            HashMap vars = Maps.newHashMap((Map)commonVars);
            vars.put("step", manualStep);
            InstructionStep step = new InstructionStep(manualStep, vars);
            steps.add(step);
        }
        return steps;
    }
}

