/*
 * Decompiled with CFR 0.152.
 */
package ext.deployit.community.plugin.manualstep.step;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.api.flow.StepExitCode;
import com.xebialabs.deployit.plugin.generic.freemarker.ConfigurationHolder;
import ext.deployit.community.plugin.manualstep.ci.ManualStep;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;

public class InstructionStep
implements Step {
    private ManualStep stepConfig;
    private Map<String, Object> vars;
    private boolean paused;

    public InstructionStep(ManualStep stepConfig, Map<String, Object> vars) {
        this.stepConfig = stepConfig;
        this.vars = vars;
    }

    public int getOrder() {
        return this.stepConfig.getOrder();
    }

    public String getDescription() {
        return ConfigurationHolder.resolveExpression((String)this.stepConfig.getDescription(), this.vars);
    }

    public StepExitCode execute(ExecutionContext ctx) throws Exception {
        String instructions = this.renderInstructionsTemplate();
        if (this.paused) {
            ctx.logOutput(instructions);
            return StepExitCode.SUCCESS;
        }
        this.mailInstructions(instructions, ctx);
        ctx.logOutput(instructions);
        this.paused = true;
        return StepExitCode.PAUSE;
    }

    private String renderInstructionsTemplate() throws IOException, TemplateException {
        Template loadedTemplate;
        Configuration cfg = ConfigurationHolder.getConfiguration();
        if (Strings.isNullOrEmpty((String)this.stepConfig.getInstructions()) && !Strings.isNullOrEmpty((String)this.stepConfig.getInstructionsScriptPath())) {
            loadedTemplate = cfg.getTemplate(this.stepConfig.getInstructionsScriptPath());
        } else {
            Preconditions.checkNotNull((Object)Strings.emptyToNull((String)this.stepConfig.getInstructions()), (Object)"Either instructions or instructionsScriptPath must be specified.");
            loadedTemplate = new Template("name", (Reader)new StringReader(this.stepConfig.getInstructions()), cfg);
        }
        StringWriter sw = new StringWriter();
        loadedTemplate.process(this.vars, (Writer)sw);
        return sw.toString();
    }

    private void mailInstructions(String instructions, ExecutionContext ctx) {
        if (!this.stepConfig.getToAddresses().isEmpty() && this.stepConfig.getMailServer() != null) {
            List resolvedAddresses = ConfigurationHolder.resolveExpression(this.stepConfig.getToAddresses(), this.vars);
            ctx.logOutput("Mailing instructions to " + Joiner.on((char)',').join((Iterable)resolvedAddresses));
            String resolvedFromAddress = ConfigurationHolder.resolveExpression((String)this.stepConfig.getFromAddress(), this.vars);
            String resolvedSubject = ConfigurationHolder.resolveExpression((String)this.stepConfig.getSubject(), this.vars);
            resolvedSubject = Strings.isNullOrEmpty((String)resolvedSubject) ? this.getDescription() : resolvedSubject;
            try {
                this.stepConfig.getMailServer().sendMessage(resolvedSubject, instructions, resolvedAddresses, resolvedFromAddress);
            }
            catch (MessagingException e) {
                ctx.logError("Failed to send mail.", (Throwable)e);
                ctx.logOutput(Strings.repeat((String)"-", (int)50));
            }
        }
    }
}

